% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLUSTERING-tsclust-controls.R
\name{tsclust-controls}
\alias{tsclust-controls}
\alias{partitional_control}
\alias{hierarchical_control}
\alias{tsclust-controls}
\alias{fuzzy_control}
\alias{tsclust-controls}
\alias{tadpole_control}
\alias{tsclust-controls}
\alias{tsclust_args}
\alias{tsclust-controls}
\title{Control parameters for clusterings with \code{\link[=tsclust]{tsclust()}}}
\usage{
partitional_control(pam.precompute = TRUE, iter.max = 100L, nrep = 1L,
  symmetric = FALSE, packages = character(0L), distmat = NULL,
  pam.sparse = FALSE, version = 2L)

hierarchical_control(method = "average", symmetric = FALSE,
  packages = character(0L), distmat = NULL)

fuzzy_control(fuzziness = 2, iter.max = 100L, delta = 0.001,
  packages = character(0L), symmetric = FALSE, version = 2L,
  distmat = NULL)

tadpole_control(dc, window.size, lb = "lbk")

tsclust_args(preproc = list(), dist = list(), cent = list())
}
\arguments{
\item{pam.precompute}{Logical flag. Precompute the whole distance matrix once and reuse it on
each iteration if using PAM centroids. Otherwise calculate distances at every iteration. See
details.}

\item{iter.max}{Integer. Maximum number of allowed iterations for partitional/fuzzy clustering.}

\item{nrep}{Integer. How many times to repeat clustering with different starting points.}

\item{symmetric}{Logical flag. Is the distance function symmetric? In other words, is \code{dist(x,y)}
== \code{dist(y,x)}? If \code{TRUE}, only half the distance matrix needs to be computed. Automatically
detected and overridden for the distances included in \pkg{dtwclust}.}

\item{packages}{Character vector with the names of any packages required for custom \code{proxy}
functions. Relevant for parallel computation, although since the distance entries are
re-registered in each parallel worker if needed, this is probably useless, but just in case.}

\item{distmat}{If available, the cross-distance matrix can be provided here. Only relevant for
partitional with PAM centroids, fuzzy with FCMdd centroids, or hierarchical clustering.}

\item{pam.sparse}{Attempt to use a sparse matrix for PAM centroids. See details.}

\item{version}{Which version of partitional/fuzzy clustering to use. See details.}

\item{method}{Character vector with one or more linkage methods to use in hierarchical procedures
(see \code{\link[stats:hclust]{stats::hclust()}}), the character \code{"all"} to use all of the available ones, or a function
that performs hierarchical clustering based on distance matrices (e.g. \code{\link[cluster:diana]{cluster::diana()}}). See
details.}

\item{fuzziness}{Numeric. Exponent used for fuzzy clustering. Commonly termed \code{m} in the
literature.}

\item{delta}{Numeric. Convergence criterion for fuzzy clustering.}

\item{dc}{The cutoff distance for the TADPole algorithm.}

\item{window.size}{The window.size specifically for the TADPole algorithm.}

\item{lb}{The lower bound to use with TADPole. Either \code{"lbk"} or \code{"lbi"}.}

\item{preproc}{A list of arguments for a preprocessing function to be used in \code{\link[=tsclust]{tsclust()}}.}

\item{dist}{A list of arguments for a distance function to be used in \code{\link[=tsclust]{tsclust()}}.}

\item{cent}{A list of arguments for a centroid function to be used in \code{\link[=tsclust]{tsclust()}}.}
}
\description{
Control parameters for fine-grained control.
}
\details{
The functions essentially return their function arguments in a classed list, although some checks
are performed.

Regarding parameter \code{version}: the first version of partitional/fuzzy clustering implemented
in the package always performed an extra iteration, which is unnecessary. Use version 2 to avoid
this, but bear in mind that the results may vary slightly due to the missing iteration.
}
\section{Partitional}{


When \code{pam.precompute = FALSE}, using \code{pam.sparse = TRUE} defines a sparse matrix (refer to
\code{\link[Matrix:sparseMatrix]{Matrix::sparseMatrix()}}) and updates it every iteration (except for \code{"dtw_lb"} distance). For
most cases, precomputing the whole distance matrix is still probably faster. See the timing
experiments in \code{browseVignettes("dtwclust")}.

Parallel computations for PAM centroids have the following considerations:
\itemize{
\item If \code{pam.precompute} is \code{TRUE}, both distance matrix calculations and repetitions are done in
parallel, regardless of \code{pam.sparse}.
\item If \code{pam.precompute} is \code{FALSE} and \code{pam.sparse} is \code{TRUE}, repetitions are done sequentially,
so that the distance calculations can be done in parallel and the sparse matrix updated
iteratively.
\item If both \code{pam.precompute} and \code{pam.sparse} are \code{FALSE}, repetitions are done in parallel, and
each repetition performs distance calculations sequentially, but the sparse matrix cannot be
updated iteratively.
}
}

\section{Hierarchical}{


There are some limitations when using a custom hierarchical function in \code{method}: it will
receive the lower triangular of the distance matrix as first argument (see \code{\link[stats:as.dist]{stats::as.dist()}})
and the result should support the \code{\link[stats:as.hclust]{stats::as.hclust()}} generic. This functionality was added
with the \pkg{cluster} package in mind, since its functions follow this convention, but other
functions could be used if they are adapted to work similarly.
}

\section{TADPole}{


When using TADPole, the \code{dist} argument list includes the \code{window.size} and specifies \code{norm = "L2"}.
}

