% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTimeSeries.R
\name{plotTimeSeries}
\alias{plotTimeSeries}
\title{Plotting time series}
\usage{
plotTimeSeries(x, labels = NULL, attr)
}
\arguments{
\item{x}{An object of class \code{\link[dtwSat]{twdtwTimeSeries}}, 
\code{\link[zoo]{zoo}}, or list of class \code{\link[zoo]{zoo}}.}

\item{labels}{A vector with labels of the time series. If missing, all 
elements in the list will be plotted (up to a maximum of 16).}

\item{attr}{An \link[base]{integer} vector or \link[base]{character} vector 
indicating the attribute for plotting. If not declared the function will plot 
all attributes.}
}
\value{
A \link[ggplot2]{ggplot} object.
}
\description{
Method for plotting the temporal patterns.
}
\examples{
ts = twdtwTimeSeries(MOD13Q1.ts.list)
plotTimeSeries(ts)
plotTimeSeries(ts, attr="evi")

}
\references{
\insertRef{Maus:2019}{dtwSat}
  
  \insertRef{Maus:2016}{dtwSat}
}
\seealso{
\code{\link[dtwSat]{twdtwTimeSeries-class}} and 
\code{\link[dtwSat]{plotPatterns}}
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
