% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time-from-ints.R
\name{dtt_time_from_ints}
\alias{dtt_time_from_ints}
\title{Create Time from Vectors}
\usage{
dtt_time_from_ints(hour = 0L, minute = 0L, second = 0L)
}
\arguments{
\item{hour}{An integer of the hour between 0 and 23.The default value is hour
zero.}

\item{minute}{An integer of the minute between 0 to 59. The default value is
minute zero.}

\item{second}{An integer of the second between 0 to 59. The default value is
second zero.}
}
\value{
A floored hms vector.
}
\description{
Pass vectors of hour, minute and second values to create a time object.
}
\details{
This can be very helpful when needing to create a time column in a
data frame from hour, minute and second columns. Vectors must all be the
same length or be of length one.
}
\examples{
dtt_time_from_ints()

dtt_time_from_ints(
  hour = 10,
  minute = 15,
  second = 30
)

dtt_time_from_ints(
  hour = c(10, 11),
  minute = c(15, 15),
  second = c(30, 0)
)

hour <- c(9, 10, 11)
minute <- c(15, 30, 45)
second <- 0
dtt_time_from_ints(hour, minute, second)
}
\seealso{
Other creates: 
\code{\link{dtt_date_from_ints}()},
\code{\link{dtt_date_time_from_ints}()}
}
\concept{creates}
