% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stable.R
\name{stable}
\alias{stable}
\title{Main function to calculate stability coefficients}
\usage{
stable(formula, data, methods = c("lm", "rpart", "tree", "ctree", "evtree"),
  samp.method = "repeatedcv", tuneLength = 3, n.rep = 100,
  bump.rep = 50, parallel = FALSE, ncore = detectCores() - 1,
  roundVal = 1, stablelearner = FALSE, subset = FALSE, perc.sub = 0.75,
  weights = NULL)
}
\arguments{
\item{formula}{a formula, weight a response to left of ~.}

\item{data}{Data frame to run models on}

\item{methods}{Which tree methods to use. Defaults:
lm, rpart, tree, ctree, evtree. Also can use "rf" for random forests}

\item{samp.method}{Sampling method. Refer to caret package trainControl()
documentation. Default is repeated cross-validation. Other options
include "cv" and "boot".}

\item{tuneLength}{Number of tuning parameters to try. Applies to train()}

\item{n.rep}{Number of times to replicate each method}

\item{bump.rep}{Number of repetitions for bumping}

\item{parallel}{Whether to run all reps in parallel}

\item{ncore}{Number of cores to use}

\item{roundVal}{How much to round cut points when calculating stability}

\item{stablelearner}{Whether or not to use the stablelearner package to
calculate stability}

\item{subset}{Whether to subset}

\item{perc.sub}{What fraction of data to put into train dataset. 1-frac.sub
is allocated to test dataset. Defaults to 0.75}

\item{weights}{Optional weights for each case.}
}
\description{
Main function to calculate stability coefficients
}
\examples{
\dontrun{
library(MASS) # for boston data
data(Boston)
stab.out <- stable(formula=medv ~.,data=Boston,
            methods=c("rpart"),samp.method="cv",
            tuneLength=2, n.rep=5, parallel=TRUE)
stab.out
}
}
