% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtps_flow_chart.R
\name{dtpflow}
\alias{dtpflow}
\title{Produce DTP flow diagram}
\usage{
dtpflow(dtptable, cohort.labels = c('C1', 'C2', 'C3'))
}
\arguments{
\item{dtptable}{a dataframe produced by calculate_dtps where cohort_sizes was of length 3.}

\item{cohort.labels}{A vector of length 3, containing character strings for
the cohort labels.}
}
\description{
dtpflow will produce a flow diagram of the possible paths for
    the next three cohorts of subjects.
}
\details{
The function will produce a visual flow diagram for the first three
    cohorts of the provided dataframe.
}
\examples{

prior  <- c(0.1, 0.2, 0.5)
target <- 0.15
prev_tox <- c(0, 0, 0)
prev_dose <- c(2, 2, 2)
cohort_sizes <- c(2, 3, 3)

next_dose = applied_crm(prior = prior, target = target,
                        tox = prev_tox, level = prev_dose)$mtd

dose_func <- applied_crm

DTP = calculate_dtps(next_dose, cohort_sizes, prev_tox = prev_tox,
                      prev_dose = prev_dose, dose_func = applied_crm,
                      prior = prior, target = target)

dtpflow(dtptable = DTP, cohort.labels = c('C1', 'C2', 'C3'))

}
\keyword{CRM}
\keyword{DTP}
\keyword{dtpcrm}
