% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plautrans.R
\name{plautrans}
\alias{plautrans}
\title{Plausibility transformation of the singletons of a frame}
\usage{
plautrans(x)
}
\arguments{
\item{x}{A bca mass function.}
}
\value{
The matrix of singletons with their plausibility transformation added in the last column.
}
\description{
Given a mass function defined on some subsets of a frame \eqn{\Theta}, the application of the plausibility transformation to the singletons of \eqn{\Theta} yields the probability distribution associated with this mass function.
}
\details{
We compute the plausibility measure of all the singletons of the frame of discernment. The probability distribution of the singletons is obtained from their plausibility measures.
}
\examples{
 
x <- bca(tt = matrix(c(0,1,1,1,1,0,1,1,1),nrow = 3, 
byrow = TRUE), m = c(0.2,0.5, 0.3), 
cnames = c("a", "b", "c"), 
varnames = "x", varnb = 1)
plautrans(x)
}
\references{
Cobb, B. R. and Shenoy, P.P. (2006). On the plausibility transformation method for translating belief function models to probability models. Journal of Approximate Reasoning, 41(3), April 2006, 314--330.
}
\author{
Claude Boivin
}
