% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score-permutations.R
\name{score_od}
\alias{score_od}
\title{Predict Isolation Scores}
\usage{
score_od(x_train, x_test, n_trees = 500L, threshold = 0.6)
}
\arguments{
\item{x_train}{Training (reference) sample.}

\item{x_test}{Test sample.}

\item{n_trees}{The number of trees in isolation forest.}

\item{threshold}{Decision threshold. Set to a default value of 0.6,
following Chabchoub et al. (2022). Outlier scores higher than the threshold
are considered outliers, and lower values are inliers.}
}
\value{
A named list or object of class \code{outlier.test} containing:
\itemize{
   \item \code{train}: vector of scores in training set
   \item \code{test}: vector of scores in test set
}
}
\description{
Predict isolation scores using (extended) isolation forest with the
\pkg{isotree} package. The prefix \emph{od} stands for outlier detection,
the relevant notion of outlyingness. This function is useful to test for
dataset shift via density-based scores: isolation scores are inversely
related, if not quite proportional, to densities.
}
\section{Notes}{

Isolation forest detects \emph{isolated} points that are typically
out-of-distribution relative to the high-density regions of the data
distribution. Any performant method for density-based out-of-distribution
detection can replace isolation forest. The decision threshold,
\code{threshold}, clips (winsorizes) the scores so that lower scores are
set to the threshold value.
}

\examples{
\donttest{
library(dsos)
set.seed(12345)
data(iris)
setosa <- iris[1:50, 1:4] # Training sample: Species == 'setosa'
versicolor <- iris[51:100, 1:4] # Test sample: Species == 'versicolor'
score_od(setosa, versicolor)
}
}
\references{
Liu, F. T., Ting, K. M., & Zhou, Z. H. (2008, December).
\emph{Isolation forest}.
In 2008 Eighth IEEE International Conference on Data Mining (pp. 413-422).
IEEE.

Chabchoub, Y., Togbe, M. U., Boly, A., & Chiky, R. (2022).
\emph{An in-depth study and improvement of Isolation Forest.}.
IEEE Access, 10, 10219-10237.

#' @details
\code{score_od} first fits to the training data and then predict in-sample
for this reference sample. Then it predicts out-of-sample for the test set.
As a result, estimating p-value via permutations require refitting the
algorithm for every permutation.
}
\seealso{
Other scoring: 
\code{\link{score_cp}()},
\code{\link{score_rd}()},
\code{\link{score_rue}()}
}
\concept{scoring}
