% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mom2par.R
\name{mom2par}
\alias{mom2par}
\title{Moments to Parameters}
\usage{
mom2par(mean = 0, sd = 1, skew = 0, s = -1, distr = "normhnorm")
}
\arguments{
\item{mean}{numeric vector of means.}

\item{sd}{numeric vector of standard deviations. Must be positive.}

\item{skew}{numeric vector of skewness. \code{s*skew} must be positive.}

\item{s}{integer; \eqn{s=-1} for production and \eqn{s=1} for cost function.}

\item{distr}{string; determines the distribution:\cr
`normhnorm`, Normal-halfnormal distribution \cr
`normexp`, Normal-exponential distribution \cr}
}
\value{
Returns a matrix where the first column corresponds to \eqn{\mu}, the second to \eqn{\sigma_V} and the third to \eqn{\sigma_U}.
}
\description{
Calculates the parameters of composed-error distribution based on the provided moments.
}
\details{
See \code{\link{dcomper}} for details of the distribution. For the inverse transformation see \code{\link{par2mom}}.
}
\examples{
mom2par(mean=0, sd=1, skew=-0.5, s=-1, distr="normhnorm")
mom2par(mean=0, sd=1, skew=-1, s=-1, distr="normexp")

}
