% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.r
\name{histmean}
\alias{histmean}
\title{Compute the mean of a data set}
\usage{
histmean(data, freq = NULL)
}
\arguments{
\item{data}{A numeric vector of a data set.}

\item{freq}{A frequency vector corresponding to the \code{data} vector.
The default value is \code{NULL}, which means all frequencies are one.}
}
\value{
The mean of a data set.
}
\description{
Compute the mean of a data set
represented by the pair of the numeric vectors \code{data} and optionally its
frequency vector \code{freq}.
}
\examples{
## Without a frequency data
histmean(mix2gauss$n200)
## With a frequency data
histmean(mix2gaussHist$n200p, mix2gaussHist$n200f)
}
\seealso{
\code{\link[=datastats]{datastats()}}
}
