# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Normalize distribution
#'
#' Normalizes the distribution so that the total mass equals 1.
#' @aliases normalize
#' @param d A vector with `length(qp)` elements representing
#' the unscaled density at each quadrature point.
#' @param qp Vector of equally spaced quadrature points.
#' @return A vector of `length(d)` elements with
#' the prior density estimate at each quadature point.
#' @note: Internal function
#' @examples
#' dscore:::normalize(c(5, 10, 5), qp = c(0, 1, 2))
#'
#' sum(dscore:::normalize(rnorm(5), qp = 1:5))
normalize <- function(d, qp) {
    .Call('_dscore_normalize', PACKAGE = 'dscore', d, qp)
}

#' Calculate posterior for one item given score, difficulty and prior
#'
#' @details
#' This function assumes that the difficulties have been estimated by
#' a binary Rasch model, e.g. by `rasch.pairwise.itemcluster()` of
#' the `sirt` package.
#'
#' @aliases posterior
#' @param score Integer, either 0 (fail) and 1 (pass)
#' @param tau Numeric, difficulty parameter
#' @param prior Vector of prior values on quadrature points `qp`
#' @param qp vector of equally spaced quadrature points
#' @param scale expansion relative to the logit scale
#' @return A vector of length `length(prior)`
#' @author Stef van Buuren, Arjan Huizing, 2020
#' @note: Internal function
#' @seealso [dscore()]
posterior <- function(score, tau, prior, qp, scale) {
    .Call('_dscore_posterior', PACKAGE = 'dscore', score, tau, prior, qp, scale)
}

#' Calculate posterior of ability
#'
#' If the tauj is not within the range rello - relhi from the
#' dynamic EAP, the procedure ignores the score of item j.
#' @param scores A vector with PASS/FAIL observations.
#' Scores are coded numerically as `pass = 1` and `fail = 0`.
#' @param tau A vector containing the item difficulties for the item
#' scores in `scores` estimated from the Rasch model in the
#' preferred metric/scale.
#' @param qp Numeric vector of equally spaced quadrature points.
#' @param scale Scale expansion
#' @param mu Numeric scalar. The mean of the prior.
#' @param sd Numeric scalar. Standard deviation of the prior.
#' @param relhi Positive numeric scalar. Upper end of the relevance interval
#' @param rello Negative numeric scalar. Lower end of the relevance interval
#' @author Stef van Buuren, Arjan Huizing, 2020
#' @return A `list` with three elements:
#'
#' | Name | Label |
#' | --- | --------- |
#' `eap` | Mean of the posterior
#' `gp`  | Vector of quadrature points
#' `posterior` | Vector with posterior distribution.
#'
#' Since `dscore V40.1` the function does not return the `"start"` element.
calculate_posterior <- function(scores, tau, qp, scale, mu, sd, relhi, rello) {
    .Call('_dscore_calculate_posterior', PACKAGE = 'dscore', scores, tau, qp, scale, mu, sd, relhi, rello)
}

