% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{what_wday}
\alias{what_wday}
\title{What day of the week is it?}
\usage{
what_wday(when = Sys.Date(), abbr = FALSE)
}
\arguments{
\item{when}{Date (as a scalar or vector).
Default: \code{when = Sys.Date()}. 
Aiming to convert \code{when} into "Date"  
if a different object class is provided.}

\item{abbr}{Boolean: Return abbreviated?
Default: \code{abbr = FALSE}.}
}
\description{
\code{what_wday} provides a satisficing version of 
to determine the day of the week  
corresponding to a given date.
}
\details{
\code{what_wday} returns the name of the weekday  
of \code{when} or of \code{Sys.Date()} 
(as a character string).
}
\examples{
what_wday()
what_wday(abbr = TRUE)

what_wday(Sys.Date() + -1:1)  # Date (as vector)
what_wday(Sys.time())         # POSIXct
what_wday("2020-02-29")       # string (of valid date)
what_wday(20200229)           # number (of valid date)

# date vector (as characters):
ds <- c("2020-01-01", "2020-02-29", "2020-12-24", "2020-12-31")
what_wday(when = ds)
what_wday(when = ds, abbr = TRUE)

# time vector (strings of POSIXct times):
ts <- c("1969-07-13 13:53 CET", "2020-12-31 23:59:59")
what_wday(ts)

# fame data:
greta_dob <- as.Date(fame[grep(fame$name, pattern = "Greta") , ]$DOB, "\%B \%d, \%Y")
what_wday(greta_dob)  # Friday, of course.

}
\seealso{
\code{what_date()} function to obtain dates; 
\code{what_time()} function to obtain times; 
\code{cur_time()} function to print the current time; 
\code{cur_date()} function to print the current date; 
\code{now()} function of the \strong{lubridate} package; 
\code{Sys.time()} function of \strong{base} R.

Other date and time functions: 
\code{\link{change_time}()},
\code{\link{change_tz}()},
\code{\link{cur_date}()},
\code{\link{cur_time}()},
\code{\link{days_in_month}()},
\code{\link{diff_dates}()},
\code{\link{diff_times}()},
\code{\link{diff_tz}()},
\code{\link{is_leap_year}()},
\code{\link{what_date}()},
\code{\link{what_month}()},
\code{\link{what_time}()},
\code{\link{what_week}()},
\code{\link{what_year}()},
\code{\link{zodiac}()}
}
\concept{date and time functions}
