% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{posPsy_AHI_CESD}
\alias{posPsy_AHI_CESD}
\title{Positive Psychology: AHI CESD data.}
\format{
A table with 992 cases (rows) and 50 variables (columns).
}
\source{
\strong{Articles}

\itemize{

\item Woodworth, R. J., O’Brien-Malone, A., Diamond, M. R., & Schüz, B. (2017). 
Web-based positive psychology interventions: A reexamination of effectiveness. 
\emph{Journal of Clinical Psychology}, \emph{73}(3), 218--232. 
doi: \code{10.1002/jclp.22328} 

\item Woodworth, R. J., O’Brien-Malone, A., Diamond, M. R. and Schüz, B. (2018). 
Data from, ‘Web-based positive psychology interventions: A reexamination of effectiveness’. 
\emph{Journal of Open Psychology Data}, \emph{6}(1). 
doi: \code{10.5334/jopd.35}
}

See \url{https://openpsychologydata.metajnl.com/articles/10.5334/jopd.35/} for details 
and \url{https://doi.org/10.6084/m9.figshare.1577563.v1} for original dataset. 

Additional references at \url{https://bookdown.org/hneth/ds4psy/B-1-datasets-pos.html}.
}
\usage{
posPsy_AHI_CESD
}
\description{
\code{posPsy_AHI_CESD} is a dataset containing answers to the 24 items of the 
Authentic Happiness Inventory (AHI) and answers to the 
20 items of the Center for Epidemiological Studies Depression (CES-D) scale 
(Radloff, 1977) for multiple (1 to 6) measurement occasions.
}
\details{
\strong{Codebook} 

\itemize{

\item 1. \strong{id}: Participant ID. 

\item 2. \strong{occasion}: Measurement occasion: 
  0: Pretest (i.e., at enrolment),   
  1: Posttest (i.e., 7 days after pretest),   
  2: 1-week follow-up, (i.e., 14 days after pretest, 7 days after posttest),   
  3: 1-month follow-up, (i.e., 38 days after pretest, 31 days after posttest),   
  4: 3-month follow-up, (i.e., 98 days after pretest, 91 days after posttest),   
  5: 6-month follow-up, (i.e., 189 days after pretest, 182 days after posttest).  

\item 3. \strong{elapsed.days}: Time since enrolment measured in fractional days.
 
\item 4. \strong{intervention}: Type of intervention: 
  3 positive psychology interventions (PPIs), plus 1 control condition: 
    1: "Using signature strengths", 
    2: "Three good things", 
    3: "Gratitude visit", 
    4: "Recording early memories" (control condition). 

\item 5.-28. (from \strong{ahi01} to \strong{ahi24}): Responses on 24 AHI items. 

\item 29.-48. (from \strong{cesd01} to \strong{cesd20}): Responses on 20 CES-D items. 

\item 49. \strong{ahiTotal}: Total AHI score. 

\item 50. \strong{cesdTotal}: Total CES-D score.   

}

See codebook and references at \url{https://bookdown.org/hneth/ds4psy/B-1-datasets-pos.html}.
}
\seealso{
\code{\link{posPsy_long}} for a corrected version of this file (in long format).

Other datasets: 
\code{\link{Bushisms}},
\code{\link{Trumpisms}},
\code{\link{countries}},
\code{\link{data_1}},
\code{\link{data_2}},
\code{\link{data_t1_de}},
\code{\link{data_t1_tab}},
\code{\link{data_t1}},
\code{\link{data_t2}},
\code{\link{data_t3}},
\code{\link{data_t4}},
\code{\link{exp_wide}},
\code{\link{falsePosPsy_all}},
\code{\link{fame}},
\code{\link{flowery}},
\code{\link{fruits}},
\code{\link{outliers}},
\code{\link{pi_100k}},
\code{\link{posPsy_long}},
\code{\link{posPsy_p_info}},
\code{\link{posPsy_wide}},
\code{\link{t3}},
\code{\link{t4}},
\code{\link{t_1}},
\code{\link{t_2}},
\code{\link{t_3}},
\code{\link{t_4}},
\code{\link{table6}},
\code{\link{table7}},
\code{\link{table8}},
\code{\link{tb}}
}
\concept{datasets}
\keyword{datasets}
