% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_multiarm_generic.R
\name{optimal_multiarm_generic}
\alias{optimal_multiarm_generic}
\title{Generic function for optimizing multi-arm programs}
\usage{
optimal_multiarm_generic(
  n2min,
  n2max,
  stepn2,
  beta,
  alpha,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  b1,
  b2,
  b3,
  strategy,
  num_cl
)
}
\arguments{
\item{n2min}{minimal total sample size in phase II, must be divisible by 3}

\item{n2max}{maximal total sample size in phase II, must be divisible by 3}

\item{stepn2}{stepsize for the optimization over n2, must be divisible by 3}

\item{beta}{type-II error rate for any pair, i.e. \code{1 - beta} is the (any-pair) power for calculation of the sample size for phase III}

\item{alpha}{one-sided significance level/family-wise error rate}

\item{c2}{variable per-patient cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c02}{fixed cost for phase II}

\item{c03}{fixed cost for phase III}

\item{K}{constraint on the costs of the program, default: \code{Inf}, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: \code{Inf}, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: \code{-Inf}, e.g. no constraint}

\item{b1}{expected gain for effect size category "small"}

\item{b2}{expected gain for effect size category "medium"}

\item{b3}{expected gain for effect size category "large"}

\item{strategy}{choose strategy: 1 (only the best promising candidate), 2 (all promising candidates) or 3 (both strategies)}

\item{num_cl}{number of clusters used for parallel computing, default: 1}
}
\description{
Generic function for optimizing multi-arm programs
}
\keyword{internal}
