% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_binary_generic.R
\name{optimal_binary_generic}
\alias{optimal_binary_generic}
\title{Generic function for optimizing programs with binary endpoints}
\usage{
optimal_binary_generic(
  w,
  p0,
  p11,
  p12,
  in1,
  in2,
  n2min,
  n2max,
  stepn2,
  rrgomin,
  rrgomax,
  steprrgo,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K = Inf,
  N = Inf,
  S = -Inf,
  steps1 = 1,
  stepm1 = 0.95,
  stepl1 = 0.85,
  b1,
  b2,
  b3,
  gamma = 0,
  fixed = FALSE,
  num_cl = 1
)
}
\arguments{
\item{w}{weight for \href{https://web.imbi.uni-heidelberg.de/prior/}{mixture prior distribution}}

\item{p0}{assumed true rate of control group, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{p11}{assumed true rate of treatment group, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{p12}{assumed true rate of treatment group, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{in1}{amount of information for \code{p11} in terms of sample size, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{in2}{amount of information for \code{p12} in terms of sample size, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{n2min}{minimal total sample size for phase II; must be an even number}

\item{n2max}{maximal total sample size for phase II, must be an even number}

\item{stepn2}{step size for the optimization over n2; must be an even number}

\item{rrgomin}{minimal threshold value for the go/no-go decision rule}

\item{rrgomax}{maximal threshold value for the go/no-go decision rule}

\item{steprrgo}{step size for the optimization over RRgo}

\item{alpha}{one-sided significance level}

\item{beta}{type II error rate; i.e. \code{1 - beta} is the power for calculation of the number of events for phase III}

\item{c2}{variable per-patient cost for phase II in 10^5 $}

\item{c3}{variable per-patient cost for phase III in 10^5 $}

\item{c02}{fixed cost for phase II in 10^5 $}

\item{c03}{fixed cost for phase III in 10^5 $}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g. no constraint}

\item{steps1}{lower boundary for effect size category "small" in RR scale, default: 1}

\item{stepm1}{lower boundary for effect size category "medium" in RR scale = upper boundary for effect size category "small" in RR scale, default: 0.95}

\item{stepl1}{lower boundary for effect size category "large" in RR scale = upper boundary for effect size category "medium" in RR scale, default: 0.85}

\item{b1}{expected gain for effect size category "small"}

\item{b2}{expected gain for effect size category "medium"}

\item{b3}{expected gain for effect size category "large"}

\item{gamma}{to model different populations in phase II and III choose \code{gamma != 0}, default: 0, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE p11 is used as fixed effect for p1}

\item{num_cl}{number of clusters used for parallel computing, default: 1}
}
\description{
Generic function for optimizing programs with binary endpoints
}
\keyword{internal}
