% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{f_dose_new_cpp}
\alias{f_dose_new_cpp}
\title{Dosing Date Imputation for New Patients}
\usage{
f_dose_new_cpp(
  usubjid,
  V,
  C,
  D,
  model_k0,
  theta_k0,
  model_t0,
  theta_t0,
  mu0,
  sigma0,
  model_ki,
  theta_ki,
  muT,
  sigmaT
)
}
\arguments{
\item{usubjid}{The unique subject ID.}

\item{V}{Initialized to 0 and corresponds to the randomization visit.}

\item{C}{The cutoff date relative to randomization.}

\item{D}{The discontinuation date relative to randomization.}

\item{model_k0}{The model for the number of skipped visits between
randomization and the first drug dispensing visit.}

\item{theta_k0}{The model parameters for the number of skipped
visits between randomization and the first drug dispensing visit.}

\item{model_t0}{The model for the gap time between randomization
and the first drug dispensing visit when there is no visit skipping.}

\item{theta_t0}{The model parameters for the gap time between
randomization and the first drug dispensing visit when there is
no visit skipping.}

\item{mu0}{The regression coefficient for the linear model for the gap
time between randomization and the first drug dispensing visit
when there is visit skipping.}

\item{sigma0}{The residual standard deviation for the linear model
for the gap time between randomization and the first drug
dispensing visit when there is visit skipping.}

\item{model_ki}{The model for the number of skipped visits between
two consecutive drug dispensing visits.}

\item{theta_ki}{The model parameters for the number of skipped
visits between two consecutive drug dispensing visits.}

\item{muT}{The regression coefficient for the linear model for the gap
time between two consecutive drug dispensing visits.}

\item{sigmaT}{The residual standard deviation the linear model for the
gap time between two consecutive drug dispensing visits.}
}
\value{
A data frame with two variables:

* \code{usubjid}: The unique subject ID.

* \code{day}: The dosing visit date relative to randomization.
}
\description{
Imputes the dosing dates for new patients and ongoing
patients with no dosing records.
}
\examples{
set.seed(529)

f_dose_new_cpp(
  usubjid = "Z001", V = 0, C = 87, D = 985,
  model_k0 = "zip", theta_k0 = c(0.6, 1.1),
  model_t0 = "log-logistic", theta_t0 = c(-1.0, 0.7),
  mu0 = 21.5, sigma0 = 1.9,
  model_ki = "zip", theta_ki = c(0.1, 0.4),
  muT = 21, sigmaT = 2.3)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
