% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{drake_failed}
\alias{drake_failed}
\title{List failed targets.
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}}
\usage{
drake_failed(cache = drake::drake_cache(path = path), path = NULL)
}
\arguments{
\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{path}{Path to a \code{drake} cache
(usually a hidden \verb{.drake/} folder) or \code{NULL}.}
}
\value{
A character vector of target names.
}
\description{
List the targets that quit in error during \code{\link[=make]{make()}}.
}
\examples{
\dontrun{
isolate_example("contain side effects", {
if (suppressWarnings(require("knitr"))) {
# Build a plan doomed to fail:
bad_plan <- drake_plan(x = function_doesnt_exist())
cache <- storr::storr_environment() # optional
try(
  make(bad_plan, cache = cache, history = FALSE),
  silent = TRUE
) # error
drake_failed(cache = cache) # "x"
e <- diagnose(x, cache = cache) # Retrieve the cached error log of x.
names(e)
e$error
names(e$error)
}
})
}
}
\seealso{
\code{\link[=drake_done]{drake_done()}}, \code{\link[=drake_running]{drake_running()}}, \code{\link[=drake_cancelled]{drake_cancelled()}},
\code{\link[=drake_progress]{drake_progress()}}, \code{\link[=make]{make()}}
}
