% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis-sankey.R
\name{sankey_drake_graph}
\alias{sankey_drake_graph}
\title{Show a Sankey graph of your drake project.}
\usage{
sankey_drake_graph(config, file = character(0), selfcontained = FALSE,
  build_times = "build", digits = 3, targets_only = FALSE,
  from = NULL, mode = c("out", "in", "all"), order = NULL,
  subset = NULL, make_imports = TRUE, from_scratch = FALSE,
  group = NULL, clusters = NULL, show_output_files = TRUE, ...)
}
\arguments{
\item{config}{A \code{\link[=drake_config]{drake_config()}} configuration list.
You can get one as a return value from \code{\link[=make]{make()}} as well.}

\item{file}{Name of a file to save the graph.
If \code{NULL} or \code{character(0)}, no file is saved and
the graph is rendered and displayed within R.
If the file ends in a \code{.png}, \code{.jpg}, \code{.jpeg}, or \code{.pdf} extension,
then a static image will be saved. In this case,
the webshot package and PhantomJS are required:
\code{install.packages("webshot"); webshot::install_phantomjs()}.
If the file does not end in a \code{.png}, \code{.jpg}, \code{.jpeg}, or \code{.pdf}
extension, an HTML file will be saved, and you can open the
interactive graph using a web browser.}

\item{selfcontained}{Logical, whether
to save the \code{file} as a self-contained
HTML file (with external resources base64 encoded) or a file with
external resources placed in an adjacent directory. If \code{TRUE},
pandoc is required.}

\item{build_times}{Character string or logical.
If character, the choices are
1. \code{"build"}: runtime of the command plus the time
it take to store the target or import.
2. \code{"command"}: just the runtime of the command.
3. \code{"none"}: no build times.
If logical, \code{build_times} selects whether to show the
times from `build_times(..., type = "build")`` or use
no build times at all. See \code{\link[=build_times]{build_times()}} for details.}

\item{digits}{Number of digits for rounding the build times}

\item{targets_only}{Logical,
whether to skip the imports and only include the
targets in the workflow plan.}

\item{from}{Optional collection of target/import names.
If \code{from} is nonempty,
the graph will restrict itself to
a neighborhood of \code{from}.
Control the neighborhood with
\code{mode} and \code{order}.}

\item{mode}{Which direction to branch out in the graph
to create a neighborhood around \code{from}.
Use \code{"in"} to go upstream,
\code{"out"} to go downstream,
and \code{"all"} to go both ways and disregard
edge direction altogether.}

\item{order}{How far to branch out to create
a neighborhood around \code{from}. Defaults to
as far as possible. If a target is in the neighborhood, then
so are all of its custom \code{\link[=file_out]{file_out()}} files if
\code{show_output_files} is \code{TRUE}.
That means the actual graph order may be slightly greater than
you might expect, but this ensures consistency
between \code{show_output_files = TRUE} and
\code{show_output_files = FALSE}.}

\item{subset}{Optional character vector.
Subset of targets/imports to display in the graph.
Applied after \code{from}, \code{mode}, and \code{order}.
Be advised: edges are only kept for adjacent nodes in \code{subset}.
If you do not select all the intermediate nodes,
edges will drop from the graph.}

\item{make_imports}{Logical, whether to make the imports first.
Set to \code{FALSE} to increase speed and risk using obsolete information.}

\item{from_scratch}{Logical, whether to assume all the targets
will be made from scratch on the next \code{\link[=make]{make()}}.
Makes all targets outdated, but keeps information about
build progress in previous \code{\link[=make]{make()}}s.}

\item{group}{Optional character scalar, name of the column used to
group nodes into columns. All the columns names of your \code{config$plan}
are choices. The other choices (such as \code{"status"}) are column names
in the \code{nodes} . To group nodes into clusters in the graph,
you must also supply the \code{clusters} argument.}

\item{clusters}{Optional character vector of values to cluster on.
These values must be elements of the column of the \code{nodes} data frame
that you specify in the \code{group} argument to \code{drake_graph_info()}.}

\item{show_output_files}{Logical, whether to include
\code{\link[=file_out]{file_out()}} files in the graph.}

\item{...}{Arguments passed to \code{networkD3::sankeyNetwork()}.}
}
\value{
A \code{visNetwork} graph.
}
\description{
To save time for repeated plotting,
this function is divided into
\code{\link[=drake_graph_info]{drake_graph_info()}} and \code{\link[=render_sankey_drake_graph]{render_sankey_drake_graph()}}.
A legend is unfortunately unavailable
for the graph itself
(\url{https://github.com/christophergandrud/networkD3/issues/240})
but you can see what all the colors mean with
\code{visNetwork::visNetwork(drake::legend_nodes())}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
config <- drake_config(my_plan)
if (requireNamespace("networkD3", quietly = TRUE)) {
if (requireNamespace("visNetwork", quietly = TRUE)) {
# Plot the network graph representation of the workflow.
sankey_drake_graph(config, width = '100\%') # The width is passed to visNetwork
# Show the legend separately.
visNetwork::visNetwork(nodes = drake::legend_nodes())
make(my_plan) # Run the project, build the targets.
sankey_drake_graph(config) # The black nodes from before are now green.
# Plot a subgraph of the workflow.
sankey_drake_graph(config, from = c("small", "reg2"))
# Optionally visualize clusters.
config$plan$large_data <- grepl("large", config$plan$target)
sankey_drake_graph(
  config, group = "large_data", clusters = c(TRUE, FALSE))
# You can even use clusters given to you for free in the `graph$nodes`
# data frame of `drake_graph_info()`.
sankey_drake_graph(config, group = "status", clusters = "imported")
}
}
}
})
}
}
\seealso{
\code{\link[=render_sankey_drake_graph]{render_sankey_drake_graph()}}, \code{\link[=vis_drake_graph]{vis_drake_graph()}},
\code{\link[=drake_ggraph]{drake_ggraph()}}
}
