% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-progress.R
\name{running}
\alias{running}
\title{List running targets.}
\usage{
running(path = getwd(), search = TRUE, cache = drake::get_cache(path
  = path, search = search, verbose = verbose), verbose = 1L)
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{Logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{verbose}{Logical or numeric, control printing to the console.
\itemize{
\item \code{0} or \code{FALSE}: print nothing.
\item \code{1} or \code{TRUE}: print only targets to build.
\item \code{2}: plus checks and cache info.
\item \code{3}: plus missing imports.
\item \code{4}: plus all imports.
\item \code{5}: plus execution and total build times for targets.
\item \code{6}: plus notifications when targets are being stored.
}}
}
\value{
A character vector of target names.
}
\description{
List the targets that either
(1) are currently being built during a call to \code{\link[=make]{make()}}, or
(2) if \code{\link[=make]{make()}} was interrupted, the targets that were running
at the time.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
running() # Everything should be done.
# nolint start
# Run make() in one R session...
# slow_plan <- drake_plan(x = Sys.sleep(2))
# make(slow_plan)
# and see the progress in another session.
# running()
# nolint end
}
})
}
}
\seealso{
\code{\link[=failed]{failed()}}, \code{\link[=make]{make()}}
}
