% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-read.R
\name{eager_load_target}
\alias{eager_load_target}
\title{Load a target right away (internal function)}
\usage{
eager_load_target(target, cache, namespace, envir, verbose)
}
\arguments{
\item{target}{If \code{character_only} is \code{TRUE}, then
\code{target} is a character string naming the object to read.
Otherwise, \code{target} is an unquoted symbol with the name of the
object.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{namespace}{Optional character string,
name of the \code{storr} namespace to read from.}

\item{envir}{Environment to load objects into. Defaults to the
calling environment (current workspace).}

\item{verbose}{Logical or numeric, control printing to the console.
\itemize{
\item \code{0} or \code{FALSE}: print nothing.
\item \code{1} or \code{TRUE}: print only targets to build.
\item \code{2}: plus checks and cache info.
\item \code{3}: plus missing imports.
\item \code{4}: plus all imports.
\item \code{5}: plus execution and total build times for targets.
\item \code{6}: plus notifications when targets are being stored.
}}
}
\description{
This function is only exported
to make active bindings work safely.
It is not actually a user-side function.
}
\keyword{internal}
