% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{drake_gc}
\alias{drake_gc}
\title{Do garbage collection on the drake cache.}
\usage{
drake_gc(path = getwd(), search = TRUE, verbose = 1, cache = NULL,
  force = FALSE)
}
\arguments{
\item{path}{file path to the folder containing the cache.
Yes, this is the parent directory containing the cache,
not the cache itself, and it assumes the cache is in the
`.drake` folder. If you are looking for a different cache
with a known folder different from `.drake`, use
the \code{\link{this_cache}()} function.}

\item{search}{logical, whether to search back in the file system
for the cache.}

\item{verbose}{logical, whether to print the location of the cache}

\item{cache}{the \code{drake}/\code{storr} cache object itself,
if available.}

\item{force}{logical, whether to load the cache
despite any back compatibility issues with the
running version of drake.}
}
\value{
\code{NULL}
}
\description{
The cache is a key-value store.
By default, the \code{\link{clean}()} function removes
values, but not keys.
Garbage collection removes the remaining dangling files.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
make(my_plan) # Run the project, build the targets.
# At this point, check the size of the '.drake/' cache folder.
# Clean without garbage collection.
clean(garbage_collection = FALSE)
# The '.drake/' cache folder is still about the same size.
drake_gc() # Do garbage collection on the cache.
# The '.drake/' cache folder should have gotten much smaller.
})
}
}
\seealso{
\code{\link{clean}}
}
