% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotgraph.R
\name{plot_graph}
\alias{plot_graph}
\title{Function \code{plot_graph}}
\usage{
plot_graph(plan = drake::plan(), targets = drake::possible_targets(plan),
  envir = parent.frame(), verbose = TRUE, cache = drake::get_cache(),
  jobs = 1, parallelism = drake::default_parallelism(),
  packages = (.packages()), prework = character(0), config = NULL,
  file = character(0), selfcontained = FALSE, build_times = TRUE,
  digits = 3, targets_only = FALSE, split_columns = FALSE,
  font_size = 20, layout = "layout_with_sugiyama", main = NULL,
  direction = "LR", hover = TRUE, navigationButtons = TRUE, ...)
}
\arguments{
\item{plan}{workflow plan data frame, same as for function
\code{\link{make}()}.}

\item{targets}{names of targets to build, same as for function
\code{\link{make}()}.}

\item{envir}{environment to import from, same as for function
\code{\link{make}()}. \code{config$envir} is ignored in favor
of \code{envir}.}

\item{verbose}{logical, whether to output messages to the console.}

\item{cache}{optional drake cache. See code{\link{new_cache}()}. If
The \code{cache} argument is ignored if a non-null \code{config}
argument is supplied.}

\item{jobs}{The \code{outdated()} function is called internally,
and it needs to import objects and examine your
input files to see what has been updated. This could take some time,
and parallel computing may be needed
to speed up the process. The \code{jobs} argument is number of parallel jobs
to use for faster computation.}

\item{parallelism}{Choice of parallel backend to speed up the computation.
Execution order in \code{\link{make}()} is slightly different when
\code{parallelism} equals \code{'Makefile'} because in that case,
all the imports are imported before any target is built.
Thus, the arrangement in the graph is different for Makefile parallelism.
See \code{?parallelism_choices} for details.}

\item{packages}{same as for \code{\link{make}()}.}

\item{prework}{same as for \code{\link{make}()}.}

\item{config}{option internal runtime parameter list of
\code{\link{make}(...)},
produced with \code{\link{config}()}.
\code{Config} overrides all arguments except
\code{file}, \code{selfcontained}, \code{build_times},
\code{digits}, \code{targets_only}, \code{split_columns},
\code{font_size}, \code{layout}, \code{main}, \code{direction},
\code{hover}, \code{navigationButtons}, and \code{...}.
Computing \code{config}
in advance could save time if you plan multiple calls to
\code{outdated()}.}

\item{file}{Name of HTML file to save the graph.
If \code{NULL} or \code{character(0)},
no file is saved and the graph is rendered and displayed within R.}

\item{selfcontained}{logical, whether to save
the \code{file} as a self-contained
HTML file (with external resources base64 encoded) or a file with
external resources placed in an adjacent directory. If \code{TRUE},
pandoc is required.}

\item{build_times}{logical, whether to print the \code{\link{build_times}()}
in the graph.}

\item{digits}{number of digits for rounding the build times}

\item{targets_only}{logical, whether to skip the imports and only show the
targets in the workflow plan.}

\item{split_columns}{logical, whether to break up the
columns of nodes to make the aspect ratio of the rendered
graph closer to 1:1. This improves the viewing experience,
but the columns no longer strictly represent parallelizable
stages of build items. (Although the targets/imports
in each column are still conditionally independent,
there may be more conditional independence than the graph
indicates.)}

\item{font_size}{numeric, font size of the node labels in the graph}

\item{layout}{name of an igraph layout
to use, such as 'layout_with_sugiyama'
or 'layout_as_tree'. Be careful with
'layout_as_tree': the graph is a directed
acyclic graph, but not necessarily a tree.}

\item{main}{title of the graph}

\item{direction}{an argument to
\code{visNetwork::visHierarchicalLayout()}
indicating the direction of the graph.
Options include 'LR', 'RL', 'DU', and 'UD'.
At the time of writing this, the letters must be capitalized,
but this may not always be the case ;) in the future.}

\item{hover}{logical, whether to show the command that generated the target
when you hover over a node with the mouse. For imports, the label does not
change with hovering.}

\item{navigationButtons}{logical, whether to add navigation buttons with
\code{visNetwork::visInteraction(navigationButtons = TRUE)}}

\item{...}{other arguments passed to
\code{visNetwork::visNetwork()} to plot the graph.}
}
\description{
Plot the dependency structure of your workflow.
IMPORTANT: you must be in the root directory of your project.
To save time for repeated plotting, this function is divided into
\code{\link{dataframes_graph}()} and \code{\link{render_graph}()}.
}
\examples{
\dontrun{
load_basic_example()
plot_graph(my_plan, width = '100\%') # The width is passed to visNetwork
make(my_plan)
plot_graph(my_plan) # The red nodes from before are now green.
}
}
\seealso{
\code{\link{build_graph}}
}
