% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autocomplete_input.R
\name{autocomplete_input}
\alias{autocomplete_input}
\alias{update_autocomplete_input}
\title{Creates an autocomplete text input field}
\usage{
autocomplete_input(id, label, options, value = "", width = NULL,
  placeholder = NULL, max_options = 0, hide_values = FALSE)

update_autocomplete_input(session, id, label = NULL, options = NULL,
  max_options = NULL, value = NULL, placeholder = NULL,
  hide_values = NULL)
}
\arguments{
\item{id}{id of the element}

\item{label}{label to show for the input, NULL for no label}

\item{options}{list (or vector) of possible options}

\item{value}{initial value}

\item{width}{optional, the width of the input, see
\code{\link[shiny:validateCssUnit]{validateCssUnit}}}

\item{placeholder}{optional character specifying the placeholder text}

\item{max_options}{optional numeric specifying the maximum number of
options to show (for performance reasons)}

\item{hide_values}{optional boolean indicating whether to show values
under labels or not}

\item{session}{the shiny session object}
}
\value{
autocomplete_input: shiny input element

update_autocomplete_input: message to the client
}
\description{
autocomplete_input creates an autocomplete text input field,
showing all possible options from a given list under the input while typing.
Alternative to very slow select(ize) inputs for (very) large option lists.

update_autocomplete_input changes the value or the options of an
autocomplete input element on the client side.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
opts <- sapply(1:100000, function(i) paste0(sample(letters, 9), collapse=""))
shinyApp(
  ui = fluidPage(
    fluidRow(
      column(3,
        autocomplete_input("auto1", "Unnamed:", opts, max_options = 1000),
        autocomplete_input("auto2", "Named:", max_options = 1000,
          structure(opts, names = opts[order(opts)])),
        autocomplete_input("auto3", "Big data:", NULL, max_options = 1000,
          placeholder = "Big data taking several seconds to load ..."),
        actionButton("calc", "Calculate")
      ), column(3,
        tags$label("Value:"), verbatimTextOutput("val1", placeholder = TRUE),
        tags$label("Value:"), verbatimTextOutput("val2", placeholder = TRUE)
       )
    )
  ),
  server = function(input, output, session) {
    output$val1 <- renderText(as.character(input$auto1))
    output$val2 <- renderText(as.character(input$auto2))
    observeEvent(input$calc, {
      Sys.sleep(3)
      update_autocomplete_input(session, "auto3", placeholder = "Loaded!",
        options = rownames(mtcars))
    })
  }
)

}
}
\author{
richard.kunze
}
