% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hot_renderer.R
\name{dq_hot_date_renderer}
\alias{dq_hot_date_renderer}
\alias{dq_hot_empty_renderer}
\alias{dq_hot_html_renderer}
\title{rhandsontable renderer}
\usage{
dq_hot_date_renderer()

dq_hot_empty_renderer(renderer = "Autocomplete")

dq_hot_html_renderer()
}
\arguments{
\item{renderer}{rhandsontable base renderer to be adjusted, can be one of
("Autocomplete", "Base", "Checkbox", "Date", "Dropdown", "Html", "Numeric",
"Password", "Text", "Time")}
}
\value{
character containing js renderer
}
\description{
dq_hot_date_renderer: Renderer to show rhandsontable dates in
proper formatting.

dq_hot_empty_renderer: Renderer to highlight empty cells in
rhandsontable.

dq_hot_html_renderer: Renderer to replace missing "html"
rhandsontable renderer.
}
\examples{
df <- data.frame(empty = rep(c("value", ""), 5),
  html = paste0("<div style='background:#ff",sprintf("\%x",25*1:10),"ff'>&nbsp;</div>"),
  date = seq(from = Sys.Date(), by = "days", length.out = 10),
  stringsAsFactors = FALSE)

hot <- rhandsontable::rhandsontable(df, rowHeaders = NULL)
hot <- rhandsontable::hot_col(hot, 1, renderer = dq_hot_empty_renderer())
hot <- rhandsontable::hot_col(hot, 2, renderer = dq_hot_html_renderer())
hot <- rhandsontable::hot_col(hot, 3, renderer = dq_hot_date_renderer())
hot
}
\author{
richard.kunze
}
