% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpm.R
\name{update}
\alias{update}
\alias{update.dpm}
\alias{update,dpm-method}
\alias{show,dpm-method}
\alias{coef}
\alias{coef.dpm}
\alias{coef,dpm-method}
\alias{formula,dpm-method}
\title{Various methods for \code{dpm} objects}
\usage{
update(object, ...)

\method{update}{dpm}(object, formula., ..., evaluate = TRUE)

\S4method{update}{dpm}(object, formula., ..., evaluate = TRUE)

\S4method{show}{dpm}(object)

coef(object, ...)

\method{coef}{dpm}(object)

\S4method{coef}{dpm}(object)

\S4method{formula}{dpm}(x)
}
\arguments{
\item{object}{A \code{dpm} object}

\item{...}{Other arguments to update.}

\item{formula.}{An updated formula (optional)}

\item{evaluate}{If updating, should the updated model be updated or just
return the call? Default is TRUE, re-run the model.}

\item{x}{A \code{dpm} object}
}
\value{
\strong{\code{update.dpm()}}: Returns an updated \code{dpm} object.

\strong{\code{coef.dpm()}}: Returns a numeric vector of coefficients. If the model
was fit with \code{x.free = TRUE} and/or \code{y.free = TRUE}, the coefficient
names will be formatted with an underscore and the wave corresponding to
which time period the coefficient is estimated for.

\strong{\code{formula.dpm()}}: Returns the formula used to fit the model as a
\code{Formula} object. The formula is the input to \code{dpm()}, not the \code{lavaan}
syntax.

\strong{\code{show.dpm()}}: Returns an invisible "NULL" while printing model info
to console.
}
\description{
R likes it when these things have documentation.
}
\examples{

data("WageData", package = "panelr")
wages <- panel_data(WageData, id = id, wave = t)
fit <- dpm(wks ~ pre(lag(union)) + lag(lwage), data = wages)

# Re-run model without `lag(lwage)` term
update(fit, . ~ . - lag(lwage))

}
