% Generated by roxygen2 (4.0.1): do not edit by hand
\name{select_vars}
\alias{rename_vars}
\alias{rename_vars_q}
\alias{select_vars}
\alias{select_vars_q}
\title{Select variables.}
\usage{
select_vars(vars, ..., env = parent.frame(), include = character(),
  exclude = character())

select_vars_q(vars, args, env = parent.frame(), include = character(),
  exclude = character())

rename_vars(vars, ...)

rename_vars_q(vars, args)
}
\arguments{
\item{vars}{A character vector of existing column names.}

\item{...,args}{Expressions to compute}

\item{include,exclude}{Character vector of column names to always
include/exclude.}
}
\value{
A named character vector. Values are existing column names,
  names are new names.
}
\description{
\code{select()} implements a rich set of tools for including (and excluding)
variables. \code{rename()} is simpler, but always includes all variables in
the original order: you can only change their names, not their positions.
}
\examples{
# Keep variables
select_vars(names(iris), starts_with("Petal"))
select_vars(names(iris), ends_with("Width"))
select_vars(names(iris), contains("etal"))
select_vars(names(iris), matches(".t."))
select_vars(names(iris), Petal.Length, Petal.Width)

df <- as.data.frame(matrix(runif(100), nrow = 10))
df <- df[c(3, 4, 7, 1, 9, 8, 5, 2, 6, 10)]
select_vars(names(df), num_range("V", 4:6))

# Drop variables
select_vars(names(iris), -starts_with("Petal"))
select_vars(names(iris), -ends_with("Width"))
select_vars(names(iris), -contains("etal"))
select_vars(names(iris), -matches(".t."))
select_vars(names(iris), -Petal.Length, -Petal.Width)

# Rename variables
select_vars(names(iris), petal_length = Petal.Length)
select_vars(names(iris), petal = starts_with("Petal"))

# Rename variables preserving all existing
rename_vars(names(iris), petal_length = Petal.Length)
}
\keyword{internal}

