% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dpcr.R
\name{read_redf}
\alias{read_redf}
\title{Read digital PCR raw data}
\usage{
read_redf(input, ext = NULL)
}
\arguments{
\item{input}{name of the input file (\code{character}) or input object 
(\code{data.frame}).}

\item{ext}{extension of the file ().}
}
\value{
An object of \code{\linkS4class{adpcr}} or \code{\linkS4class{dpcr}} type, 
depends on the value of \code{adpcr} parameter.
}
\description{
Reads REDF (Raw Exchange Digital PCR format) data.
}
\details{
REDF (Raw Exchange Digital PCR format) data is preferably a .csv file 
with following columns:
\describe{
\item{experiment}{names of experiments}
\item{replicate}{indices of replicates}
\item{assay}{names of assays}
\item{k}{number of positive partitions}
\item{n}{total number of partitions}
\item{v}{volume of partition (nL)}
\item{uv}{uncertainty of partition's volume (nL)}
\item{threshold}{partitions with \code{k} equal or higher than threshold are 
treated as positve.}
\item{panel_id}{indices of panels}
}
Column \code{panel_id} should be specified only in case of 
array-based dPCR.
}
\author{
Michal Burdukiewcz, Stefan Roediger
}
\keyword{utilities}
