\name{test_ratio}
\alias{test_ratio}
\alias{test_ratio,numeric}
\alias{test_ratio,adpcr}
\alias{test_ratio,ddpcr}
\alias{test_ratio,numeric-method}
\alias{test_ratio,adpcr-method}
\alias{test_ratio,ddpcr-method}
\alias{test_ratio,numeric,numeric-method}
\alias{test_ratio,adpcr,adpcr-method}
\alias{test_ratio,ddpcr,ddpcr-method}
\title{
Rate ratio test
}
\description{
The test for comparing ratio of two Poisson means: 
\eqn{r = \frac{\lambda_1}{\lambda_2}}{r = \lambda_1/\lambda_2}.
}
\usage{
\S4method{test_ratio}{numeric,numeric}(dpcr1, dpcr2, alternative = c("two.sided", "less", 
                                        "greater"),conf.level = 0.95)
\S4method{test_ratio}{adpcr,adpcr}(dpcr1, dpcr2, alternative = c("two.sided", "less", "greater"),
                                    conf.level = 0.95)
\S4method{test_ratio}{ddpcr,ddpcr}(dpcr1, dpcr2, alternative = c("two.sided", "less", "greater"),
                                    conf.level = 0.95)
}
\arguments{
  \item{dpcr1}{
a (non-empty) numeric vector of data values of length 2 or more or an object of class 
\code{\linkS4class{adpcr}} or \code{\linkS4class{ddpcr}}. See Details.
}
  \item{dpcr2}{
a (non-empty) numeric vector of data values of length 2 or more or an object of class 
\code{\linkS4class{adpcr}} or \code{\linkS4class{ddpcr}}. See Details.
}
  \item{alternative}{
alternative hypothesis, must be one of: \code{two.sided}, \code{greater} or \code{less}.
}
  \item{conf.level}{
confidence level for the returned confidence interval.
}
}
\details{
Objects \code{dpcr1} and \code{dpcr2} can be:
\enumerate{
    \item numeric vectors of length 2. The first element is assumed to be number of positive
    partitions and the second one to be the total number of partitions.
    \item numeric vectors of length greater than 2. The length of vector is assumed to 
    represent total
    number of partitions. Every element of the vector with value bigger than 0 is assumed to be
    a positive partitions.
    \item \code{\linkS4class{adpcr}} objects with type \code{tp} (total number of positive wells 
    in panel) or \code{nm} (number of molecules per partition).
    \code{\linkS4class{ddpcr}} objects with type \code{tp} (total number of positive droplets) or
    \code{nm} (number of molecules per droplet).
  }
Both \code{dpcr1} and \code{dpcr2} must have the same class. See Examples.

The \code{ratio_test} is a wrapper around \link[rateratio.test]{rateratio.test} function with 
custom input and output tailored specifically for digital PCR experiments.
}

\value{
 An object of class `htest' containing the following components:
 \item{p.value}{the p-value of the test}
\item{estimate}{a vector with the means (lambdas) of both experiments and their ratio}
\item{conf.int}{confidence interval for ratio between two experiments.}
\item{alternative}{type of alternative hypothesis}
\item{method}{description of method}
\item{data.name}{description of data}
}
\references{
  Fay M.P.
  \emph{Two-sided exact tests and matching confidence intervals for discrete data}
  R Journal 2 (1), 
  2010.
}
\author{
Michael Fay, Michal Burdukiewicz, Stefan Roediger
}

\seealso{
See also \code{\link[stats]{poisson.test}}.
}

\examples{
# Input values are numeric vectors representing dPCR experiments
x1 <- rpois(765, 1.1)
x2 <- rpois(765, 1.1)
test_ratio(x1, x2)

# Input values represent only number of positive partitions and total 
# partitions
x3 <- sum(rpois(765, 1.1) > 0)
x4 <- sum(rpois(765, 1.1) > 0)
test_ratio(c(x3, 765), c(x4, 765))

# It is possible to mix different types of input as long as they have 
# the same class
test_ratio(c(x3, 765), x1)

# The same is true for adpcr and dpcr objects.
x5 <- sim_adpcr(400, 1600, 100, pos_sums = TRUE, n_panels = 1)
x6 <- sim_adpcr(400, 1600, 100, pos_sums = FALSE, n_panels = 1)
test_ratio(x5, x6)

x7 <- sim_ddpcr(400, 1600, 100, pos_sums = TRUE, n_exp = 1)
x8 <- sim_ddpcr(400, 1600, 100, pos_sums = FALSE, n_exp = 1)
test_ratio(x7, x8)
}

\keyword{ compare }
\keyword{ mean }
\keyword{ poisson }
