
<!-- README.md is generated from README.Rmd. Please edit that file -->

# downloadthis <img src='man/figures/logo.png' align="right" height="240" />

<!-- badges: start -->

[![Lifecycle:
stable](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://www.tidyverse.org/lifecycle/#stable)
[![CRAN
status](https://www.r-pkg.org/badges/version-ago/downloadthis)](https://CRAN.R-project.org/package=downloadthis)
[![R build
status](https://github.com/fmmattioni/downloadthis/workflows/R-CMD-check/badge.svg)](https://github.com/fmmattioni/downloadthis)
[![Monthly downloads
badge](https://cranlogs.r-pkg.org/badges/last-month/downloadthis?color=blue)](https://CRAN.R-project.org/package=downloadthis)
[![Total downloads
badge](https://cranlogs.r-pkg.org/badges/grand-total/downloadthis?color=blue)](https://CRAN.R-project.org/package=downloadthis)
<!-- badges: end -->

The goal of `downloadthis` is to implement download buttons in HTML
output from RMarkdown without the need for `runtime:shiny`.

## Installation

You can install the released version of `downloadthis` from
[CRAN](https://CRAN.R-project.org/package=downloadthis) with:

``` r
install.packages("downloadthis")
```

You can install the development version of `downloadthis` from
[GitHub](https://github.com/fmmattioni/downloadthis/) with:

``` r
# install.packages("remotes")
remotes::install_github("fmmattioni/downloadthis")
```

## Introduction

This package builds the download button in R Markdown using
[bsplus](https://github.com/ijlyttle/bsplus), and it was inspired on
[this post](https://yihui.org/en/2018/07/embed-file/) from [Yihui
Xie](https://github.com/yihui).

## Example

``` r
library(downloadthis)

mtcars %>% 
  download_this(
    output_name = "mtcars data set",
    output_extension = ".csv",
    button_label = "Download data",
    button_type = "warning",
    has_icon = TRUE,
    icon = "fa fa-save"
  )
```

<!--html_preserve-->

<a href="data:application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;base64,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" download="mtcars data set.xlsx">
<button class="btn btn-warning"><i class="fa fa-save"></i> Download
data</button> </a><!--/html_preserve-->

## Code of Conduct

Please note that this project is released with a [Contributor Code of
Conduct](https://www.contributor-covenant.org/version/1/0/0/code-of-conduct.html).
By participating in this project you agree to abide by its
terms.

## Support

<a href="https://www.buymeacoffee.com/XQauwUWGm" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png" alt="Buy Me A Coffee" style="height: 41px !important;width: 174px !important;box-shadow: 0px 3px 2px 0px rgba(190, 190, 190, 0.5) !important;-webkit-box-shadow: 0px 3px 2px 0px rgba(190, 190, 190, 0.5) !important;" ></a>
