% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance.R
\name{covar.smd}
\alias{covar.smd}
\title{Computes mean and standardized mean differences for continuous outcome with corresponding
co(variance) matrix}
\usage{
covar.smd(y, sd, n, measure = "md", method = "cohens", data)
}
\arguments{
\item{y}{a vector defining the mean outcome for each treatment level.}

\item{sd}{a vector defining the standard deviation of the outcome for each treatment level.}

\item{n}{a vector defining the number of subjects for each treatment level.}

\item{measure}{character string, indicating the measure to be calculated. Options are \code{md}
and \code{smd} for mean difference and standardized mean difference, respectively.}

\item{method}{character string indicating the method to be used. Options are \code{cohens}, \code{hedges}, and \code{glass}.}

\item{data}{an optional data frame (or object coercible by \code{\link{as.data.frame}} to a data frame) containing the variables in the previous arguments.}
}
\value{
A list containing the following
\tabular{ll}{
\code{y} \tab mean or standardized mean differences for each treatment level,
included the referent one (0 by calculation).\cr
\code{v} \tab variances corresponding to the mean or standardized mean differences for each 
treatment level, included the referent one (0 by calculation)\cr
\code{S} \tab co(variance) matrix for the non-referent mean or standardized mean differences.\cr
}
}
\description{
This internal function computes mean and standardized mean of a continuous outcome with the corresponding 
variances. It also reconstructs the covariance matrix from the available data.
}
\details{
This is an internal function called by \code{\link{dosresmeta}} to reconstruct the (co)variance matrix of the 
outcome variable. The function is expected to be extended and/or modified at every release of the package
}
\examples{
## Loading the data
data("ari")

## Obtaining standardized mean differences, variances, and (co)varinace 
## matrix for the first study (id = 1)
covar.smd(y, sd, n, measure = "smd", data = subset(ari, id == 1))

## Obtaining mean differences, variances, and (co)varinace matrices for the all the studies
cov.md <- by(ari, ari$id, function(x) covar.smd(y, sd, n, "md", data = x))

## Extracting mean differences
unlist(lapply(cov.md, function(x) x$y))
## Extracting variances for the mean differences
unlist(lapply(cov.md, function(x) x$v))
## List of the (co)variance matrices for the mean differences
lapply(cov.md, function(x) x$S)
 
}
\references{
Cooper, H., Hedges, L. V., & Valentine, J. C. (Eds.). (2009). The handbook of 
research synthesis and meta-analysis. Russell Sage Foundation.
}
\seealso{
\code{\link{covar.logrr}}, \code{\link{dosresmeta}}
}
\author{
Alessio Crippa, \email{alessio.crippa@ki.se}
}
