% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additional.R
\name{fracpol}
\alias{fracpol}
\title{Fractional Polynomials}
\usage{
fracpol(x, p = c(1, 1), shift, scale, scaling = TRUE)
}
\arguments{
\item{x}{a numeric vector.}

\item{p}{a vector of length 2 with the powers of x to be included.}

\item{shift}{optional scalar representing the shift, if \code{scaling = TRUE}. If not specified it is se
internally equal to 0.}

\item{scale}{optional scalar representing the scale, if \code{scaling = TRUE}. If not specified it is se
internally equal to 1.}

\item{scaling}{a logical indicating if the measurements are scaled prior to model fitting.}
}
\value{
A matrix including the trasformations corresponding to the input values.
}
\description{
Two-order fractional polynomials transformation for continuous covariates.
}
\details{
The \code{fracpol} is based on the \code{FP} function in the \code{mboost} package.
See \code{help(FP)} for more details.
}
\examples{
## Load data and run the model
data("alcohol_cvd")

with(alcohol_cvd, fracpol(dose, p = c(.5, .5)))

model <- dosresmeta(formula = logrr ~ fracpol(dose, p = c(.5, .5)), type = type, id = id,
                    se = se, cases = cases, n = n, data = alcohol_cvd) 
                    
## Test for significance of the overall dose-response association
waldtest(b = coef(model), Sigma = vcov(model), Terms = 1:nrow(vcov(model)))

}
\references{
Royston, Patrick, and Douglas G. Altman. "Regression using fractional polynomials of 
continuous covariates: parsimonious parametric modelling." Applied Statistics (1994): 429-467.
}
\seealso{
\code{mboost}, \code{rcs.eval}
}
\author{
Alessio Crippa, \email{alessio.crippa@ki.se}
}
