% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_find_tbls.r
\name{docx_extract_tbl}
\alias{docx_extract_tbl}
\title{Extract a table from a Word document}
\usage{
docx_extract_tbl(docx, tbl_number = 1, header = TRUE, trim = TRUE)
}
\arguments{
\item{docx}{\code{docx} object read with \code{read_docx}}

\item{tbl_number}{which table to extract (defaults to \code{1})}

\item{header}{assume first row of table is a header row? (default; \code{TRUE})}

\item{trim}{trim leading/trailing whitespace (if any) in cells? (default: \code{TRUE})}
}
\value{
\code{data.frame}
}
\description{
Given a document read with \code{read_docx} and a table to extract (optionally
indicating whether there was a header or not and if cell whitepace trimming is
desired) extract the contents of the table to a \code{data.frame}.
}
\examples{
doc3 <- read_docx(system.file("examples/data3.docx", package="docxtractr"))
docx_extract_tbl(doc3, 3)
}
\seealso{
\code{\link{docx_extract_all}}, \code{\link{docx_extract_tbl}},
         \code{\link{assign_colnames}}
}

