% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_engr.R
\name{format_engr}
\alias{format_engr}
\title{Format numerical variables in engineering notation.}
\usage{
format_engr(x, sigdig = NULL, ambig_0_adj = FALSE)
}
\arguments{
\item{x}{A data frame with numeric variables to be formatted.}

\item{sigdig}{An optional vector of significant digits.}

\item{ambig_0_adj}{An optional logical to adjust the format
to remove ambiguous trailing zeros. If TRUE, the decimal point is
moved three places to the left. Default is FALSE.}
}
\value{
A data frame with numeric variables converted
  to formatted strings bounded by \code{"$...$"}.
}
\description{
Converts numeric variables in a data frame into character variables
formatted in engineering notation. The formatted character variables
are delimited with \code{$...$} for rendering as inline math.
}
\details{
Engineering notation is a subset of scientific notation: the exponent of
ten must be divisible by three. Powers of ten are written with a product
symbol (the LaTeX \code{\\times} symbol), not computer E-notation. The
numerical output strings are bounded by \code{$...$} for rendering in
math mode.

The output format is "coefficient x 10^exponent" except for exponents equal
to 0, 1, or 2. In these cases, the output format is floating-point.

The input argument is a data frame with at least one numeric variable.
Only double variables (not integers and not dates) are formatted in
powers of ten.

The function distinguishes between integers that represent factors and
those that represent numerical integers. Numerical integers are returned
as characters in math mode. Factors and other non-numeric variables
are returned unaffected.

Each double variable (except dates) can be assigned its own number
of significant digits. The default is 4. If \code{sigdig} is a single
value, it is used for all variables; if a vector, it must have the
same number of elements as there are double variables in the data frame.
Setting \code{sigdig = 0} returns the double variables as characters
but unaltered.

For numbers with no decimal point, trailing zeros can be ambiguous.
Such numbers can be optionally reported with the decimal moved an
additional three places to the left.

To learn more about docxtools, start with the vignettes:
\code{browseVignettes(package = "docxtools")}.
}
\examples{
# Factors unaffected; ambiguous trailing zeros.
data("CO2")
x <- as.data.frame(head(CO2, n = 5L))
format_engr(x)
format_engr(x, sigdig = c(0, 3))
format_engr(x, sigdig = c(3, 3), ambig_0_adj = TRUE)

# Ordered factor unaffected; ambiguous trailing zeros.
data("DNase")
x <- as.data.frame(tail(DNase, n = 5L))
format_engr(x)
format_engr(x, sigdig = c(6, 3))
format_engr(x, sigdig = c(6, 3), ambig_0_adj = TRUE)

# Integers returned unchanged but delimited; NA unchanged.
data("airquality")
x <- head(airquality, n = 6L)
format_engr(x, sigdig = 3)

}
