% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx2pdf.R
\name{docx2pdf}
\alias{docx2pdf}
\title{Convert docx to pdf}
\usage{
docx2pdf(input, output = gsub("\\\\.docx$", ".pdf", input))
}
\arguments{
\item{input, output}{file input and optional file output (default
to input with pdf extension).}
}
\value{
the name of the produced pdf (the same value as \code{output})
}
\description{
Convert docx to pdf directly using "Microsoft Word".
This function will not work if "Microsoft Word" is not available
on your machine.

The calls to "Microsoft Word" are made differently depending on the
operating system:
\itemize{
\item On "Windows", a "PowerShell" script using COM
technology is used to control "Microsoft Word". The resulting PDF
is containing a browsable TOC.
\item On macOS, an "AppleScript" script is used to control "Microsoft Word".
The resulting PDF is not containing a browsable TOC as when on 'Windows'.
}
}
\section{Macos manual authorizations}{

On macOS the call is happening into a working
directory managed with function \code{\link[=working_directory]{working_directory()}}.

Manual interventions are necessary to authorize 'Word' and
'PowerPoint' applications to write in a single directory: the working directory.
These permissions must be set manually, this is required by the macOS security
policy. We think that this is not a problem because it is unlikely that you will
use a Mac machine as a server.

You must click "allow" two times to:
\enumerate{
\item allow R to run 'AppleScript' scripts that will control Word
\item allow Word to write to the working directory.
}

This process is a one-time operation.
}

\examples{
library(locatexec)
if (exec_available('word')) {
  file <- system.file(package = "doconv",
    "doc-examples/example.docx")

  out <- docx2pdf(input = file,
    output = tempfile(fileext = ".pdf"))

  if (file.exists(out)) {
    message(basename(out), " is existing now.")
  }
}
}
