% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.r
\name{docket}
\alias{docket}
\title{Create documents}
\usage{
docket(filename, dictionary, outputName)
}
\arguments{
\item{filename}{The file path to the document template}

\item{dictionary}{A data frame where each row represents a flag in the template document and its replacement value}

\item{outputName}{The file path and name for the saved output document}
}
\value{
Generates a new .doc or .docx file with the flags replaced by the specified data
}
\description{
Scans the input template file for specified flags as defined in the dictionary,
and replaces them with corresponding data. The edited content is then saved to a new document
}
\examples{
# Path to the sample template included in the package
template_path <- system.file("template_document", "Template.docx", package="docket")
output_path <- paste0(dirname(template_path), "/output document.docx")

# Create a dictionary by using the getDictionary function on the sample template file
result <- getDictionary(template_path)

# Insert data into the template dictionary
result[1,2] <- Sys.getenv("USERNAME") #Author name
result[2,2] <- as.character(Sys.Date()) # Date report created
result[3,2] <- 123
result[4,2] <- 456
result[5,2] <- 789
result[6,2] <- sum(as.numeric(result[3:5,2]))

# Verify that the result dictionary is valid
if (checkDictionary(result) == TRUE) {
  docket(template_path, result, output_path)
  if (file.exists(output_path)) {
     print("Docket Successfully Created")
  }
}
}
