% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recover_pca_data.R
\name{recover_pca_data}
\alias{recover_pca_data}
\title{Recover data from principal component analysis}
\usage{
recover_pca_data(object, comp = 1)
}
\arguments{
\item{object}{An object of class 'prcomp.}

\item{comp}{The number of compoents to be used. Must be smaller
than the number of variables.}
}
\value{
A dataframe
}
\description{
Recover data from principal component analysis based on the first (typically few) components.
}
\examples{

crime <- doBy::crimeRate
rownames(crime) <- crime$State
crime$State <- NULL
crime <- doBy::crimeRate
rownames(crime) <- crime$State
crime$State <- NULL

o <- order(apply(scale(crime), 1, sum))
dat <- crime[o,]
head(dat)
tail(dat)
matplot(scale(dat), type="l")

pc1 <- prcomp(dat, scale. = TRUE)
summary(pc1)
rec2 <- recover_pca_data(pc1, 2)

pairs(rec2)

par(mfrow=c(1,2))
matplot(scale(dat), type="l")
matplot(scale(rec2), type="l")


j <- merge(dat, rec2, by=0)
pairs(j[,-1])


}
