% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_pair}
\alias{plot_pair}
\title{Plot the expression values of two genes}
\usage{
plot_pair(
  x,
  gene_A,
  gene_B,
  method = "loess",
  alpha = 0.5,
  se_alpha = 0.1,
  use_facet = FALSE,
  scales = "fixed",
  colors = c(rgb(0.31, 0.58, 0.8, 0.9), rgb(1, 0.19, 0.19, 0.9))
)
}
\arguments{
\item{x}{A 'dnapath' or 'dnapath_list' object from \code{\link{dnapath}}.}

\item{gene_A}{The name of the first gene to plot. Must be one of the names
in \code{\link{get_genes}}(x).}

\item{gene_B}{The name of the second gene to plot. Must be one of the names
in \code{\link{get_genes}}(x).}

\item{method}{A charater string, either "lm" or "loess" (the default)
used by \code{\link[ggplot2]{geom_smooth}} to summarize the marginal
gene-gene association. For no line, set method = NULL.}

\item{alpha}{Sets the transparancy of the points, used to set alpha in
\code{\link[ggplot2]{geom_point}}.}

\item{se_alpha}{Sets the transparancy of the confidence band around
the association trend line. Set to 0 to remove the band.}

\item{use_facet}{If TRUE, the groups are plotted in separate graphs
using the \code{link[ggplot2]{facet_wrap}} method.}

\item{scales}{Only used if do_facet_wrap is TRUE. See
\code{link[ggplot2]{facet_wrap}} for details.}

\item{colors}{A vector of length two containing the rgb colors used for the
two groups.}
}
\value{
Plots the differential network and returns the ggplot object.
Additional modifications can be applied to this object just
like any other ggplot.
}
\description{
Inspired by the \code{plotCors} function from the DGCA package,
this function is used to plot the expression values of two genes contained
in the differential network analysis results. This is useful for comparing
the marginal relationship between two genes. Note, however, that this
visualization is not able to show conditional associations.
}
\examples{
data(meso)
data(p53_pathways)
set.seed(0)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   group_labels = meso$groups, n_perm = 10)
# Plot of the marginal association between the first two genes.
genes <- get_genes(results)[1:2]
g <- plot_pair(results, genes[1], genes[2])
# The ggplot object, g, can be further modified.
# Here we move the legend and use a log scale for the expression values
# (the log scale doesn't help with these data but is shown for demonstration).
g <- g +
  ggplot2::theme(legend.position = "bottom") +
  ggplot2::scale_x_log10() +
  ggplot2::scale_y_log10()
g
}
\references{
\insertRef{seqnet}{dnapath}
}
