% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{run_glasso}
\alias{run_glasso}
\title{Wrapper for glasso method}
\usage{
run_glasso(
  x,
  method = c("glasso", "mb", "ct"),
  criterion = c("ric", "stars"),
  verbose = FALSE,
  weights = NULL,
  ...
)
}
\arguments{
\item{x}{A n by p matrix of gene expression data (n samples and p genes).}

\item{method}{Argument is passed into \code{\link[huge]{huge}}.}

\item{criterion}{Argument is passed into \code{\link[huge]{huge.select}}.}

\item{verbose}{Argument is passed into \code{\link[huge]{huge}} and
\code{\link[huge]{huge.select}}}

\item{weights}{An optional vector of weights. This is used by \code{dnapath()} to
apply the probabilistic group labels to each observation when estimating the
group-specific network.}

\item{...}{Additional arguments are ignored.}
}
\value{
A p by p matrix of association scores.
}
\description{
Conducts co-expression analysis using glasso \insertCite{friedman18}{dnapath}.
Uses the implementation from the \code{huge} package \insertCite{huge}{dnapath}.
Can be used for the \code{network_inference} argument in \code{\link{dnapath}}.
}
\examples{
data(meso)
data(p53_pathways)

# To create a short example, we subset on one pathway from the p53 pathway list,
# and will only run 1 permutation for significance testing.
pathway_list <- p53_pathways[13]
n_perm <- 1

# Use this method to perform differential network analysis.
# The parameters in run_glasso() can be adjusted using the ... argument.
# For example, the 'criterion' parameter can be specified as shown here.
results <- dnapath(x = meso$gene_expression,
                   pathway_list = pathway_list,
                   group_labels = meso$groups,
                   n_perm = n_perm,
                   network_inference = run_glasso,
                   criterion = "ric")
summary(results)

# The group-specific association matrices can be extracted using get_networks().
nw_list <- get_networks(results) # Get networks for pathway 1.

\donttest{
# nw_list has length 2 and contains the inferred networks for the two groups.
# The gene names are the Entrezgene IDs from the original expression dataset.
# Renaming the genes in the dnapath results to rename those in the networks.
# NOTE: The temporary directory, tempdir(), is used in this example. In practice,
#       this argument can be removed or changed to an existing directory
results <- rename_genes(results, to = "symbol", species = "human",
                        dir_save = tempdir())
nw_list <- get_networks(results) # The genes (columns) will have new names.

# (Optional) Plot the network using SeqNet package (based on igraph plotting).
# First rename entrezgene IDs into gene symbols.
SeqNet::plot_network(nw_list[[1]])
}
}
\references{
\insertRef{friedman18}{dnapath}

\insertRef{huge}{dnapath}
}
\seealso{
\code{\link{run_aracne}},
\code{\link{run_bc3net}}, \code{\link{run_c3net}},
\code{\link{run_clr}}, \code{\link{run_corr}},
\code{\link{run_dwlasso}}, \code{\link{run_genie3}}, \code{\link{run_mrnet}},
\code{\link{run_pcor}}, and \code{\link{run_silencer}}
}
