% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lab.R
\name{choose_test.lab}
\alias{choose_test.lab}
\title{Filter final result}
\usage{
\method{choose_test}{lab}(obj, test = "mis", group_id = T)
}
\arguments{
\item{obj}{An object. Class lab.}

\item{test}{A character scalar. Parameters, which use to filter the final dataset, default: "mis":
"ok" - analysis, which has a correct estimate of the result,
"mis" - analysis, which has an incorrect estimate of the result,
"skip" - analysis, which has an empty value of the estimate,
"null" - analysis, which has an empty result and value of the estimate.}

\item{group_id}{A logical scalar, default is TRUE.True is grouped by id, otherwise, it isn't grouped.}
}
\value{
The filtered dataset by a value of \code{test}.
}
\description{
Filter final result
}
\examples{
id <- c("01", "02", "03")
site <- c("site 01", "site 02", "site 03")
age <- c("19", "20", "22")
sex <- c("f", "m", "f")
gluc_post <- c(5.5, 4.1, 9.7)
gluc_res_post <- c("norm", "no", "cl")
ast_post <- c("30", "48", "31")
ast_res_post <- c(NA, "norm", "norm")

df <- data.frame(
  id, site, age, sex,
  gluc_post, gluc_res_post,
  ast_post, ast_res_post,
  stringsAsFactors = FALSE
)

refs <- system.file("labs_refer.xlsx", package = "dmtools")
obj_lab <- lab(refs, id, age, sex, "norm", "no")

obj_lab <- check(obj_lab, df)
choose_test(obj_lab, "mis")
}
