% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{plot.infogain_bins}
\alias{plot.infogain_bins}
\title{Visualize Distribution for an "infogain_bins" Object}
\usage{
\method{plot}{infogain_bins}(x, type = c("bar", "cross"), typographic = TRUE, base_family = NULL, ...)
}
\arguments{
\item{x}{an object of class "infogain_bins", usually, a result of a call to binning_rgr().}

\item{type}{character. options for visualization. Distribution("bar"), Relative Frequency by target ("cross").}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}

\item{...}{further arguments to be passed from or to other methods.}
}
\description{
It generates plots for understand distribution and  distribution by target variable using infogain_bins.
}
\details{
The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}
\examples{
\donttest{
# binning by recursive information gain ratio maximization using character
bin <- binning_rgr(heartfailure, "death_event", "creatinine")

# binning by recursive information gain ratio maximization using name
bin <- binning_rgr(heartfailure, death_event, creatinine)
bin

# summary optimal_bins class
summary(bin)

# visualize all information for optimal_bins class
plot(bin)

# visualize WoE information for optimal_bins class
plot(bin, type = "cross")

# visualize all information without typographic
plot(bin, type = "cross", typographic = FALSE)
}

}
\seealso{
\code{\link{binning_rgr}}, \code{\link{summary.bins}}
}
