% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.interactionfor.R
\encoding{UTF-8}
\name{plot.interactionfor}
\alias{plot.interactionfor}
\title{Plot method for \code{interactionfor} objects}
\usage{
\method{plot}{interactionfor}(x, numpairsquant = 2, numpairsqual = 2, ...)
}
\arguments{
\item{x}{Object of class \code{interactionfor}.}

\item{numpairsquant}{The number of pairs with largest quantitative EIM values to plot. Default is 2.}

\item{numpairsqual}{The number of pairs with largest qualitative EIM values to plot. Default is 2.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A ggplot2 plot.
}
\description{
Plot function for \code{interactionfor} objects that allows to obtain a first overview of the result of the
interaction forest analysis. This function visualises the distributions of the EIM values and
the estimated forms of the bivariable influences of the variable pairs with largest quantitative and 
qualitative EIM values. Further visual exploration of the result of the interaction
forest analysis should be conducted using \code{\link{plotEffects}}.
}
\details{
For details on the plots of the estimated forms of the bivariable influences of the variable pairs see \code{\link{plotEffects}}.

NOTE: The p-values shown in the plots are generally much too optimistic and \strong{MUST NOT} be reported 
as the result of a statistical test for significance of interaction. To obtain adjusted p-values that would correspond to
valid tests, it would be possible to multiply these p-values by the number of possible variable pairs, 
which would correspond to Bonferroni-adjusted p-values. See the 'Details' section of \code{\link{plotEffects}} for further
explanation and guidance.

NOTE ALSO: As described in Hornung & Boulesteix (2021), in the case of data with larger numbers of variables (larger than 100, but more seriously
for high-dimensional data), the univariable EIM values can be biased. Therefore, it is strongly recommended to interpret the univariable EIM values
with caution, if the data are high-dimensional. If it is of interest to measure the univariable importance of the variables for high-dimensional data,
an additional conventional random forest (e.g., using the \code{ranger} package) should be constructed and the variable importance measure values
of this random forest be used for ranking the univariable effects.
}
\examples{
\dontrun{

## Load package:

library("diversityForest")



## Set seed to make results reproducible:

set.seed(1234)



## Construct interaction forest and calculate EIM values:

data(stock)
model <- interactionfor(dependent.variable.name = "company10", data = stock, 
                        num.trees = 20)

# NOTE: num.trees = 20 (in the above) would be much too small for practical 
# purposes. This small number of trees was simply used to keep the
# runtime of the example short.
# The default number of trees is num.trees = 20000 if EIM values are calculated
# and num.trees = 2000 otherwise.



## When using the plot() function without further specifications,
## by default the estimated bivariable influences of the two pairs with largest quantitative
## and qualitative EIM values are shown:

plot(model)

# It is, however, also possible to change the numbers of
# pairs with largest quantitative and qualitative EIM values
# to be shown:

plot(model, numpairsquant = 4, numpairsqual = 3)

}

}
\references{
\itemize{
  \item Hornung, R. & Boulesteix, A.-L. (2021). Interaction Forests: Identifying and exploiting interpretable quantitative and qualitative interaction effects. Technical Report No. 237, Department of Statistics, University of Munich. \url{https://epub.ub.uni-muenchen.de/75432/index.html}.
  \item Hornung, R. (2022). "Diversity forests: Using split sampling to enable innovative complex split procedures in random forests". SN Computer Science 3(2):1, <\doi{10.1007/s42979-021-00920-1}>.
  }
}
\seealso{
\code{\link{plotEffects}}
}
\author{
Roman Hornung
}
