% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_gen_simpson.R
\name{div_gen_simpson}
\alias{div_gen_simpson}
\alias{div_gen_simpson.numeric}
\alias{div_gen_simpson.species_distribution}
\title{Generalized Simpson's Diversity}
\usage{
div_gen_simpson(x, k = 1, ...)

\method{div_gen_simpson}{numeric}(
  x,
  k = 1,
  estimator = c("Zhang", "naive"),
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)

\method{div_gen_simpson}{species_distribution}(
  x,
  k = 1,
  estimator = c("Zhang", "naive"),
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object, that may be a numeric vector containing abundances or probabilities,
or an object of class \link{abundances}  or \link{probabilities}.}

\item{k}{the order of Hurlbert's diversity.}

\item{...}{Unused.}

\item{estimator}{An estimator of asymptotic diversity.}

\item{as_numeric}{if \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}
}
\value{
A tibble with the site names, the estimators used and the estimated diversity.
}
\description{
Estimate the diversity sensu stricto, i.e. the effective number of species
\insertCite{Grabchak2016}{divent} from abundance or probability data.
}
\details{
Bias correction requires the number of individuals.

Estimation techniques are from \insertCite{Zhang2014;textual}{divent}.
It is limited to orders \eqn{k} less than or equal to the number of individuals
in the community.

Generalized Simpson's diversity cannot be estimated at a specified level
of interpolation or extrapolation, and diversity partitioning is not available.
}
\examples{
# Diversity of each community
div_gen_simpson(paracou_6_abd, k = 50)

}
\references{
\insertAllCited{}
}
\seealso{
\link{ent_gen_simpson}
}
