% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{tsbars}
\alias{tsbars}
\title{Function to plot a series a values with bars that have variable widths}
\usage{
tsbars(x, y, width = "max", yref = 0, gap = 0, vertical = TRUE,
  ...)
}
\arguments{
\item{x}{\code{(numeric)} Vector specifying where the centers of the bars should be on the x axis.}

\item{y}{\code{(numeric)} Vector containing the heights of the bars.}

\item{width}{\code{(numeric)} Vector containing the widths of the bars. Recycling is not supported, has to be either a single numeric value, or a numeric vector with the same length as \code{x} and \code{y}. Automatic width calculation is possible, the default \code{"max"} option sets the bar width even and equal to the the maximum width that can be used evenly witout causing overlaps. The option \code{"half"}, places the boundaries of the bars halfway between the points. This will make the bars' width asymmetrical around the \code{x} coordinates.}

\item{yref}{\code{(numeric)} Single numeric value in the y dimension indicating common base for the bars.}

\item{gap}{\code{(numeric)} The amount of gap there should be between the bars (in the unit of the plotting). Defaults to no gaps.}

\item{vertical}{\code{(logical)} Switching this option to \code{FALSE} will reverse the x and y dimensions of the plot.}

\item{...}{Arguments passed to \code{\link[graphics]{rect}}.}
}
\description{
Function to use bars for time series.
}
\details{
People often present time series with connected points, although the visual depiction implies a certain process that describes how the values change between the points.
Instead of using simple scatter plots, Barplots can be used to describe series where a single value is the most descriptive of a discreet time bin. The \code{tsbars()} function
draws rectangles of different widths with the \code{\link[graphics]{rect}} function, to plot series in such a way.
}
\examples{
# an occurrence-based example
# needed data
  data(stages)
  data(corals)
# calculate diversites
  dd <-divDyn(corals, tax="genus", bin="stg")
# plot range-through diversities
  tsplot(stages, xlim=51:94, ylim=c(0,250), boxes="sys")
  tsbars(x=stages$mid, y=dd$divRT, width=stages$dur, gap=1, col=stages$col)

}
