% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Multinomial.R
\name{random.Multinomial}
\alias{random.Multinomial}
\title{Draw a random sample from a Multinomial distribution}
\usage{
\method{random}{Multinomial}(x, n = 1L, ...)
}
\arguments{
\item{x}{A \code{Multinomial} object created by a call to \code{\link[=Multinomial]{Multinomial()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
An integer vector of length \code{n}.
}
\description{
Draw a random sample from a Multinomial distribution
}
\examples{

set.seed(27)

X <- Multinomial(size = 5, p = c(0.3, 0.4, 0.2, 0.1))
X

random(X, 10)

# pdf(X, 2)
# log_pdf(X, 2)
}
\seealso{
Other Multinomial distribution: 
\code{\link{pdf.Multinomial}()}
}
\concept{Multinomial distribution}
