% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exponential.R
\name{pdf.Exponential}
\alias{pdf.Exponential}
\alias{log_pdf.Exponential}
\title{Evaluate the probability density function of an Exponential distribution}
\usage{
\method{pdf}{Exponential}(d, x, ...)

\method{log_pdf}{Exponential}(d, x, ...)
}
\arguments{
\item{d}{An \code{Exponential} object created by a call to \code{\link[=Exponential]{Exponential()}}.}

\item{x}{A vector of elements whose probabilities you would like to
determine given the distribution \code{d}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of probabilities, one for each element of \code{x}.
}
\description{
Evaluate the probability density function of an Exponential distribution
}
\examples{

set.seed(27)

X <- Exponential(5)
X

mean(X)
variance(X)
skewness(X)
kurtosis(X)

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
