\name{Version Management}
\docType{methods}
\alias{getVersion}
\alias{getVersion-methods}
\alias{getVersion,Dataclass-method}
\alias{isOldVersion}
\alias{isOldVersion-methods}
\alias{isOldVersion,Dataclass-method}
\alias{conv2NewVersion}
\alias{conv2NewVersion-methods}
\alias{conv2NewVersion,Dataclass-method}
\title{ Methods for Version Management in Package `distrSim' }
\description{Version-Management-methods}
\section{Far-reaching Change in Design}{
 From version 1.8 of this package on, we have changed the format how data / simulations are stored:
 In order to be able to cope with multivariate distributions, regression distributions and (later)
 time series distributions, we have switched to the common array format: 
 samplesize x obsDim x runs; for saved objects from earlier versions, we provide the functions
 \code{isOldVersion} and \code{conv2NewVersion} to check whether the object was generated by an 
 older version of this package and to convert such an object to the new format, respectively. 
}
\section{Methods}{\describe{
\item{getVersion}{\code{signature(object = "Dataclass")}: returns slot \code{version} of an object
                  of class \code{"Dataclass"}.
 }
\item{isOldVersion}{\code{signature(object = "Dataclass")}: returns \code{TRUE} and a warning if slot \code{version}
 (which was introduced in version 1.8) is missing; else returns \code{FALSE}.
 }
\item{conv2NewVersion}{\code{signature(object = "Dataclass")}: 
changes an object with format runs x samplesize (old format) to 
samplesize x obsDim x runs (new format)}
 }
}
\keyword{}
