\name{ContaminationSize}
\alias{ContaminationSize}
\alias{ContaminationSize-methods}
\alias{ContaminationSize,AbscontDistribution,AbscontDistribution-method}
\alias{ContaminationSize,DiscreteDistribution,DiscreteDistribution-method}

\title{Generic Function for the Computation of the Convex Contamination 
    (Pseudo-)Distance of Two Distributions}
\description{
  Generic function for the computation of convex contamination (pseudo-)distance 
  of two probability distributions \eqn{P} and \eqn{Q}. That is, the 
  minimal size \eqn{\varepsilon\in [0,1]}{0 <= epsilon <= 1} is computed such that 
  there exists some probability distribution \eqn{R} with
  \deqn{Q = (1-\varepsilon)P + \varepsilon R}{Q = (1 - epsilon)P + epsilon R}
}
\usage{
ContaminationSize(e1, e2)
}
\arguments{
  \item{e1}{ object of class \code{"Distribution"} }
  \item{e2}{ object of class \code{"Distribution"} }
}
\details{Computes the distance from \code{e1} to \code{e2} respectively
  \eqn{P} to \eqn{Q}. This is not really a distance as it is not symmetric!}
\value{
  The size of contamination is computed.
}
\section{Methods}{
\describe{
  \item{e1 = "AbscontDistribution", e2 = "AbscontDistribution":}{
    convex contamination (pseudo-)distance of two absolutely
    continuous univariate distributions.
  }
  \item{e1 = "DiscreteDistribution", e2 = "DiscreteDistribution":}{
    convex contamination (pseudo-)distance of two discrete 
    univariate distributions.
  }
  }
}}
\references{Huber, P.J. (1981) \emph{Robust Statistics}. New York: Wiley.}
\author{Matthias Kohl \email{Matthias.Kohl@stamats.de}}
%\note{ ~~further notes~~ }
\seealso{\code{\link{KolmogorovDist}}, \code{\link{TotalVarDist}}, 
    \code{\link{HellingerDist}}, \code{\link[distr]{Distribution-class}}}
\examples{
ContaminationSize(Norm(), Norm(mean=0.1))
ContaminationSize(Pois(), Pois(1.5))
}
\concept{convex contamination}
\concept{gross error}
\keyword{distribution}
