% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exkurtosisType.R
\name{exkurtosisType}
\alias{exkurtosisType}
\title{Kurtosis Type}
\usage{
exkurtosisType(kurtosis)
}
\arguments{
\item{kurtosis}{numeric.}
}
\value{
Returns one of 'platykurtic', 'mesokurtic' or 'leptokurtic'.
}
\description{
Gets the type of (excess) kurtosis
}
\details{
Kurtosis is a measure of the tailedness of a distribution. Distributions can be compared to the
Normal distribution by whether their kurtosis is higher, lower or the same as that of the Normal
distribution.

A distribution with a negative excess kurtosis is called 'platykurtic', a distribution
with a positive excess kurtosis is called 'leptokurtic' and a distribution with an excess kurtosis equal
to zero is called 'mesokurtic'.
}
\examples{
exkurtosisType(-1)
exkurtosisType(0)
exkurtosisType(1)

}
\seealso{
\code{\link{kurtosis}}, \code{\link{skewType}}
}
