% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{importance_dtw_legacy_cpp}
\alias{importance_dtw_legacy_cpp}
\title{(C++) Contribution of Individual Variables to the Dissimilarity Between Two Time Series (Legacy Version)}
\usage{
importance_dtw_legacy_cpp(
  y,
  x,
  distance = "euclidean",
  diagonal = FALSE,
  weighted = TRUE,
  ignore_blocks = FALSE,
  bandwidth = 1
)
}
\arguments{
\item{y}{(required, numeric matrix) multivariate time series
with the same number of columns as 'x'.}

\item{x}{(required, numeric matrix) multivariate time series.}

\item{distance}{(optional, character string) distance name from the "names"
column of the dataset \code{distances} (see \code{distances$name}). Default: "euclidean".}

\item{diagonal}{(optional, logical). If TRUE, diagonals are included in the
computation of the cost matrix. Default: TRUE.}

\item{weighted}{(optional, logical). Only relevant when diagonal is TRUE. When TRUE,
diagonal cost is weighted by y factor of 1.414214 (square root of 2). Default: TRUE.}

\item{ignore_blocks}{(optional, logical). If TRUE, blocks of consecutive path
coordinates are trimmed to avoid inflating the psi distance. Default: FALSE.}

\item{bandwidth}{(required, numeric) Size of the Sakoe-Chiba band at
both sides of the diagonal used to constrain the least cost path. Expressed
as a fraction of the number of matrix rows and columns. Unrestricted by default.
Default: 1}
}
\value{
data frame
}
\description{
Computes the contribution of individual variables to the
similarity/dissimilarity between two irregular multivariate time series.
In opposition to the robust version, least-cost paths for each combination
of variables are computed independently, which makes the results of individual
variables harder to compare. This function should only be used when the objective is
replicating importance scores generated with previous versions of the package \code{distantia}.
This function generates a data frame with the following columns:
\itemize{
\item variable: name of the individual variable for which the importance
is being computed, from the column names of the arguments \code{x} and \code{y}.
\item psi: global dissimilarity score \code{psi} of the two time series.
\item psi_only_with: dissimilarity between \code{x} and \code{y} computed from the given variable alone.
\item psi_without: dissimilarity between \code{x} and \code{y} computed from all other variables.
\item psi_difference: difference between \code{psi_only_with} and \code{psi_without}.
\item importance: contribution of the variable to the similarity/dissimilarity
between \code{x} and \code{y}, computed as \code{((psi_all - psi_without) * 100) / psi_all}.
Positive scores represent contribution to dissimilarity,
while negative scores represent contribution to similarity.
}
}
\examples{
#simulate two regular time series
x <- zoo_simulate(
  seed = 1,
  rows = 100
  )

y <- zoo_simulate(
  seed = 2,
  rows = 150
  )

#different number of rows
#this is not a requirement though!
nrow(x) == nrow(y)

#compute importance
df <- importance_dtw_legacy_cpp(
  x = x,
  y = y,
  distance = "euclidean"
)

df
}
\seealso{
Other Rcpp_importance: 
\code{\link{importance_dtw_cpp}()},
\code{\link{importance_ls_cpp}()}
}
\concept{Rcpp_importance}
