% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflowPsi.R
\name{workflowPsi}
\alias{workflowPsi}
\title{Computes the dissimilarity measure \emph{psi} on two or more sequences.}
\usage{
workflowPsi(
  sequences = NULL,
  grouping.column = NULL,
  time.column = NULL,
  exclude.columns = NULL,
  method = "manhattan",
  diagonal = FALSE,
  format = "dataframe",
  paired.samples = FALSE,
  same.time = FALSE,
  ignore.blocks = FALSE,
  parallel.execution = TRUE
  )
}
\arguments{
\item{sequences}{dataframe with multiple sequences identified by a grouping column generated by \code{\link{prepareSequences}}.}

\item{grouping.column}{character string, name of the column in \code{sequences} to be used to identify separates sequences within the file.}

\item{time.column}{character string, name of the column with time/depth/rank data.}

\item{exclude.columns}{character string or character vector with column names in \code{sequences} to be excluded from the analysis.}

\item{method}{character string naming a distance metric. Valid entries are: "manhattan", "euclidean", "chi", and "hellinger". Invalid entries will throw an error.}

\item{diagonal}{boolean, if \code{TRUE}, diagonals are included in the computation of the least cost path. Defaults to \code{FALSE}, as the original algorithm did not include diagonals in the computation of the least cost path. If \code{paired.samples} is \code{TRUE}, then \code{diagonal} is irrelevant.}

\item{format}{string, type of output. One of: "data.frame", "matrix". If \code{NULL} or empty, a list is returned.}

\item{paired.samples}{boolean, if \code{TRUE}, the sequences are assumed to be aligned, and distances are computed for paired-samples only (no distance matrix required). Default value is \code{FALSE}.}

\item{same.time}{boolean. If \code{TRUE}, samples in the sequences to compare will be tested to check if they have the same time/age/depth according to \code{time.column}. This argument is only useful when the user needs to compare two sequences taken at different sites but same time frames.}

\item{ignore.blocks}{boolean. If \code{TRUE}, the function \code{\link{leastCostPathNoBlocks}} analyzes the least-cost path of the best solution, and removes blocks (straight-orthogonal sections of the least-cost path), which happen in highly dissimilar sections of the sequences, and inflate output psi values.}

\item{parallel.execution}{boolean, if \code{TRUE} (default), execution is parallelized, and serialized if \code{FALSE}.}
}
\value{
A list, matrix, or dataframe, with sequence names and psi values.
}
\description{
If the sequences are not aligned (\code{paired.samples = FALSE}), the function executes these steps.
\itemize{
\item Computes the autosum of the sequences with \code{\link{autoSum}}.
\item Computes the distance matrix with \code{\link{distanceMatrix}}.
\item Uses the distance matrix to compute the least cost matrix with \code{\link{leastCostMatrix}}.
\item Extracts the cost of the least cost path with \code{\link{leastCost}}.
\item Computes the dissimilarity measure \emph{psi} with the function \code{\link{psi}}.
\item Delivers an output of type "list" (default), "data.frame" or "matrix", depending on the user input, through \code{\link{formatPsi}}.
}

If the sequences are aligned (\code{paired.samples = TRUE}), these steps are executed:
\itemize{
\item Computes the autosum of the sequences with \code{\link{autoSum}}.
\item Sums the distances between paired samples with \code{\link{distancePairedSamples}}.
\item Computes the dissimilarity measure \emph{psi} with the function \code{\link{psi}}.
\item Delivers an output of type "list" (default), "data.frame" or "matrix", depending on the user input, through \code{\link{formatPsi}}.
}
}
\examples{

\donttest{
data("sequencesMIS")
#prepare sequences
MIS.sequences <- prepareSequences(
  sequences = sequencesMIS,
  grouping.column = "MIS",
  if.empty.cases = "zero",
  transformation = "hellinger"
  )

#execute workflow to compute psi
MIS.psi <- workflowPsi(
 sequences = MIS.sequences,
 grouping.column = "MIS",
 time.column = NULL,
 exclude.columns = NULL,
 method = "manhattan",
 diagonal = FALSE,
 parallel.execution = FALSE
 )

MIS.psi

}

}
\author{
Blas Benito <blasbenito@gmail.com>
}
