% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gains_losses.R
\name{gains_losses}
\alias{gains_losses}
\title{Gains & Losses}
\usage{
gains_losses(
  portfolio,
  market_prices,
  transaction_type,
  transaction_asset,
  transaction_quantity,
  transaction_price,
  transaction_datetime,
  previous_datetime,
  time_threshold = "0 mins",
  method = "all",
  allow_short = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{portfolio}{Data frame of the investor's portfolio at time t.}

\item{market_prices}{Data frame containing the market prices.}

\item{transaction_type}{Character string. Either "B" = buy or "S" = sell.}

\item{transaction_asset}{Character string. The name of the traded asset.}

\item{transaction_quantity}{Numeric value. The quantity of the traded asset.}

\item{transaction_price}{Numeric value. The market price of the traded asset.}

\item{transaction_datetime}{POSIXct value. The date-time at which the transaction
is going to occur.}

\item{previous_datetime}{POSIXct value. The date-time of the last transaction
performed by the investor.}

\item{time_threshold}{Character in the format "value units" indicating the
time threshold at which the computed financial difftime has to be evaluated
(for instance "05 mins" or "20 hours").
The allowed units are "secs", "mins", "hours", "days" and "weeks"
(See \code{base::\link[base:difftime]{difftime}}).}

\item{method}{Character string. The method used to compute papers.
Allowed values are "count", "total", "value", "duration" and "all".}

\item{allow_short}{Logical. If TRUE short positions are allowed, otherwise only
long positions are allowed.}

\item{verbose}{Logical. If TRUE than messages are printed to the console.}
}
\value{
A data frame containing the values of realized and paper gains
and losses computed by means of the chosen method on each portfolio assets.
}
\description{
Calculation of the realized gains and losses and the paper
gains and losses.
}
\details{
It is essentially a wrapper around \code{\link{paper_compute}}
and \code{\link{realized_compute}} functions.
It is the function that can be used for streaming computations of
gains and losses.
}
\seealso{
\code{\link{realized_compute}}, \code{\link{paper_compute}},
\code{\link{portfolio_compute}}
}
